/*
 * Decompiled with CFR 0.152.
 */
import com.cognos.CAM_AAA.authentication.INamespaceConfiguration;
import com.cognos.CAM_AAA.authentication.INamespaceTrustedSignonProvider;
import com.cognos.CAM_AAA.authentication.ITrustedSignonRequest;
import com.cognos.CAM_AAA.authentication.SystemRecoverableException;
import com.cognos.CAM_AAA.authentication.UnrecoverableException;
import com.cognos.CAM_AAA.authentication.UserRecoverableException;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class TrustedSignonMapping
extends Namespace
implements INamespaceTrustedSignonProvider {
    private static String CONFIG_FILE = "domainMapping.xml";
    private static String DOMAIN_SPLIT_DELIMITER = "domainSplitDelimiter";
    private static String DOMAIN_SPLIT_POSITION = "domainSplitPosition";
    private static String REMOTE_USER_VALUE_SPLIT = "remoteUserSplitPosition";
    private static String BEFORE = "before";
    private static String AFTER = "after";
    private HashMap<String, String> domainMapping = new HashMap();
    private String domainSplitDelimiter;
    private String domainSplitPosition;
    private String remoteUserSplitPosition;
    private String passedRemoteUserName;

    @Override
    public void init(INamespaceConfiguration iNamespaceConfiguration) throws UnrecoverableException {
        super.init(iNamespaceConfiguration);
        String string = iNamespaceConfiguration.getInstallLocation() + "/configuration";
        String string2 = string + "/" + CONFIG_FILE;
        this.readConfigInfo(string2);
    }

    private void readConfigInfo(String string) {
        try {
            String string2;
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("=");
                String string3 = stringArray[0];
                String string4 = stringArray[1].replaceAll("\\p{Cntrl}", "");
                if (string3.equalsIgnoreCase(DOMAIN_SPLIT_DELIMITER)) {
                    this.domainSplitDelimiter = string4;
                    continue;
                }
                if (string3.equalsIgnoreCase(DOMAIN_SPLIT_POSITION)) {
                    this.domainSplitPosition = string4;
                    continue;
                }
                if (string3.equalsIgnoreCase(REMOTE_USER_VALUE_SPLIT)) {
                    this.remoteUserSplitPosition = string4;
                    continue;
                }
                this.domainMapping.put(string3.toUpperCase(), string4);
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
        }
    }

    public void processLogonRequest(ITrustedSignonRequest iTrustedSignonRequest) throws UserRecoverableException, SystemRecoverableException, UnrecoverableException {
        String[] stringArray = null;
        stringArray = iTrustedSignonRequest.getTrustedEnvVarValue("REMOTE_USER");
        if (stringArray == null) {
            String[] stringArray2 = new String[]{"REMOTE_USER"};
            SystemRecoverableException systemRecoverableException = new SystemRecoverableException("Requesting trusted REMOTE_USER.", stringArray2);
            throw systemRecoverableException;
        }
        String string = this.extractUserDomainInformation(stringArray);
        String string2 = null;
        if (string != null) {
            string2 = this.mapToNamespaceID(string);
        }
        if (string2 == null) {
            UnrecoverableException unrecoverableException = new UnrecoverableException("Could not redirect to the specific namespace", "Missing domain information. Please check the system setting");
            throw unrecoverableException;
        }
        if (string2 != null) {
            iTrustedSignonRequest.setNamespaceID(string2);
        }
        iTrustedSignonRequest.removeTrustedEnvVar("REMOTE_USER");
        iTrustedSignonRequest.addTrustedEnvVar("REMOTE_USER", this.passedRemoteUserName);
    }

    private String extractUserDomainInformation(String[] stringArray) {
        int n;
        String string = null;
        this.passedRemoteUserName = stringArray[0];
        if (this.domainSplitDelimiter != null && (n = stringArray[0].indexOf(this.domainSplitDelimiter)) > 0) {
            string = this.splitValueBasedOnPosition(stringArray, n, this.domainSplitPosition);
            this.passedRemoteUserName = this.remoteUserSplitPosition != null ? this.splitValueBasedOnPosition(stringArray, n, this.remoteUserSplitPosition) : stringArray[0];
        }
        return string;
    }

    private String splitValueBasedOnPosition(String[] stringArray, int n, String string) {
        String string2 = string.equalsIgnoreCase(BEFORE) ? stringArray[0].substring(0, n) : (string.equalsIgnoreCase(AFTER) ? stringArray[0].substring(n + 1) : stringArray[0]);
        return string2;
    }

    private final String mapToNamespaceID(String string) {
        String string2 = this.domainMapping.get(string.toUpperCase());
        return string2;
    }
}

