/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class LogException
extends Exception {
    private Exception _exRootException = null;
    private ArrayList _vMessages = new ArrayList();

    public LogException() {
    }

    public LogException(String sMsg) {
        this.init(null, sMsg);
    }

    public static Exception getIPFException(Exception exIn, String sMsg) {
        return LogException.getIPFException(exIn, sMsg, LogException.class);
    }

    public static Exception getIPFException(Exception exIn, String sMsg, Class ipfexClass) {
        LogException exRet = null;
        if (exIn instanceof LogException) {
            LogException ipfex = (LogException)exIn;
            ipfex.addMessage(sMsg);
            exRet = ipfex;
        } else {
            LogException ipfex = null;
            try {
                ipfex = (LogException)ipfexClass.newInstance();
            }
            catch (Exception ex) {
                ipfex = new LogException();
            }
            ipfex.init(exIn, sMsg);
            exRet = ipfex;
        }
        return exRet;
    }

    public Exception getRootException() {
        return this._exRootException;
    }

    public void init(Exception exRoot, String sMsg) {
        this._exRootException = exRoot;
        if (sMsg != null) {
            this.addMessage(sMsg);
        }
    }

    private void addMessage(String sMsg) {
        this._vMessages.add(sMsg);
    }

    @Override
    public String getMessage() {
        String sRet = null;
        StringBuffer sb = new StringBuffer(1024);
        if (this._exRootException != null) {
            sb.append("'").append(this._exRootException.toString()).append("'");
        }
        for (int i = 0; i < this._vMessages.size(); ++i) {
            String sMsg = (String)this._vMessages.get(i);
            if (i == 0) {
                if (this._exRootException != null) {
                    sb.append("\r\n  WHILE ");
                }
            } else {
                sb.append("\r\n  WHILE ");
            }
            sb.append("'").append(sMsg).append("'");
        }
        sRet = sb.toString();
        return sRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace();
            if (this._exRootException != null) {
                System.err.println("Root cause:");
                this._exRootException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream printstream) {
        PrintStream printStream = printstream;
        synchronized (printStream) {
            super.printStackTrace(printstream);
            if (this._exRootException != null) {
                printstream.println("Root cause:");
                this._exRootException.printStackTrace(printstream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter printwriter) {
        PrintWriter printWriter = printwriter;
        synchronized (printWriter) {
            super.printStackTrace(printwriter);
            if (this._exRootException != null) {
                printwriter.println("Root cause:");
                this._exRootException.printStackTrace(printwriter);
            }
        }
    }
}

