/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.resource;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;

public final class CCLCodeList {
    private String _sCodeListName = null;
    Object _loaded_by = null;
    public static final int SORT_AS_IS = 1;
    public static final int SORT_BY_TEXT = 2;
    public static final int SORT_EXPLICIT = 3;
    private Locale _locale;
    private ArrayList _vCodeValues = new ArrayList(20);
    private ArrayList _vCodeValues_byText = null;
    private ArrayList _vCodeValues_bySort = null;
    private HashMap _mCodeValues = new HashMap(107);

    private CCLCodeList() {
    }

    public CCLCodeList(Object loaded_by, String sName, Locale locale) {
        this._loaded_by = loaded_by;
        this._locale = locale;
        this._sCodeListName = sName;
    }

    public Iterator iterator() {
        return this._mCodeValues.values().iterator();
    }

    public void addCodeValue(String sCode, String sText, String sImage, int nSort) {
        CodeValue cv = new CodeValue(sCode, sText, sImage, nSort);
        this.addCodeValue(cv);
    }

    public void addCodeValue(String sCode, String sText) {
        CodeValue cv = new CodeValue(sCode, sText);
        this.addCodeValue(cv);
    }

    private void addCodeValue(CodeValue cv) {
        String sCode = cv._sCode;
        this._vCodeValues.add(cv);
        this._vCodeValues_byText = null;
        this._vCodeValues_bySort = null;
        this._mCodeValues.put(sCode, cv);
    }

    public boolean hasCode(String sCode) {
        boolean bRet = this._mCodeValues.containsKey(sCode);
        return bRet;
    }

    private CodeValue getValue(String sCode) {
        CodeValue retVal = (CodeValue)this._mCodeValues.get(sCode);
        if (retVal == null) {
            throw new CCLRuntimeException("fetching code '" + sCode + "' from codelist '" + this._sCodeListName + "'");
        }
        return retVal;
    }

    public String getText(String sCode) {
        String sRet = null;
        CodeValue cv = this.getValue(sCode);
        sRet = cv._sText;
        return sRet;
    }

    public String getImage(String sCode) {
        String sRet = null;
        CodeValue cv = this.getValue(sCode);
        sRet = cv._sImage;
        return sRet;
    }

    public ArrayList getList() {
        return this.getList(1);
    }

    public ArrayList getList(int nSortBy) {
        ArrayList vRet = null;
        if (nSortBy == 1) {
            vRet = this._vCodeValues;
        } else if (nSortBy == 2) {
            if (this._vCodeValues_byText == null) {
                CodeValueTextComparator comp = new CodeValueTextComparator(this._locale);
                this._vCodeValues_byText = this.sortValuesUsingComparator(comp);
            }
            vRet = this._vCodeValues_byText;
        } else if (nSortBy == 3) {
            if (this._vCodeValues_bySort == null) {
                CodeValueSortComparator comp = new CodeValueSortComparator();
                this._vCodeValues_bySort = this.sortValuesUsingComparator(comp);
            }
            vRet = this._vCodeValues_bySort;
        } else {
            throw new CCLRuntimeException("invalid sort order=" + nSortBy);
        }
        return vRet;
    }

    private ArrayList sortValuesUsingComparator(Comparator comp) {
        TreeSet set = new TreeSet(comp);
        set.addAll(this._vCodeValues);
        Iterator iterSet = set.iterator();
        ArrayList vSorted = new ArrayList(this._vCodeValues.size());
        while (iterSet.hasNext()) {
            Object obj = iterSet.next();
            vSorted.add(obj);
        }
        return vSorted;
    }

    private final class CodeValueSortComparator
    implements Comparator {
        CodeValueSortComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            int nSort2;
            CodeValue v1 = (CodeValue)obj1;
            CodeValue v2 = (CodeValue)obj2;
            int nSort1 = v1.getSort();
            if (nSort1 == (nSort2 = v2.getSort())) {
                return 0;
            }
            if (nSort1 > nSort2) {
                return 1;
            }
            return -1;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    private final class CodeValueTextComparator
    implements Comparator {
        Locale _comparator_locale = null;
        Collator _comparator_collator = null;

        CodeValueTextComparator(Locale locale) {
            this._comparator_locale = locale;
            this._comparator_collator = Collator.getInstance(this._comparator_locale);
        }

        public int compare(Object obj1, Object obj2) {
            CodeValue cv1 = (CodeValue)obj1;
            CodeValue cv2 = (CodeValue)obj2;
            String s1 = cv1._sText;
            String s2 = cv2._sText;
            return this._comparator_collator.compare(s1, s2);
        }

        @Override
        public boolean equals(Object obj) {
            return this._comparator_collator.equals(obj);
        }
    }

    public class CodeValue {
        private String _sCode;
        private String _sText;
        private String _sImage;
        private int _nSort;

        public CodeValue(String sCode, String sText, String sImage, int nSort) {
            this.init(sCode, sText, sImage, nSort);
        }

        public CodeValue(String sCode, String sText) {
            this.init(sCode, sText, null, -1);
        }

        private void init(String sCode, String sText, String sImage, int nSort) {
            this._sCode = sCode;
            this._sText = sText;
            this._sImage = sImage;
            this._nSort = nSort;
        }

        public String getCode() {
            return this._sCode;
        }

        public String getText() {
            return this._sText;
        }

        public String getImage() {
            return this._sImage;
        }

        public int getSort() {
            return this._nSort;
        }
    }
}

