/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.resource;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.logging.CCLNullDebugLogger;
import com.cognos.ccl4j.logging.CCLNullServiceAuditLogger;
import com.cognos.ccl4j.logging.ICCLDebugLogging;
import com.cognos.ccl4j.logging.ICCLLoggable;
import com.cognos.ccl4j.logging.ICCLServiceAuditLogging;
import com.cognos.ccl4j.resource.CCLResource;
import com.cognos.ccl4j.resource.CCLResourceLoader;
import com.cognos.ccl4j.resource.CCLResourceManager;
import com.cognos.ccl4j.resource.ICCLResourceLoader2;
import com.cognos.ccl4j.resource.ICCLResourceManager;
import com.cognos.ccl4j.resource.ICCLResourceToLoad;
import com.cognos.ccl4j.util.CCLFileUtils;
import com.cognos.ccl4j.util.CCLShellUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CCLMessageFile
implements ICCLResourceLoader2,
ICCLLoggable {
    public static final int LOAD_FROM_DEFAULT = 1;
    public static final int LOAD_FROM_BUNDLE = 2;
    public static final int LOAD_FROM_MSGSDK = 3;
    private int _nLoadFrom = 1;
    protected ICCLResourceManager _resmgr = null;
    protected ICCLDebugLogging _logDebug = CCLNullDebugLogger.getNullLogger();
    protected ICCLServiceAuditLogging _logService = CCLNullServiceAuditLogger.getNullLogger();
    protected String _sResourceFilename = null;
    String _sResourceFilenamePrefix = null;
    String _sResourceDirpath = null;
    public boolean _bAllowMissingFile = false;
    private boolean _bAllowStringMarking = true;

    public CCLMessageFile(String sResourceFilename) {
        this.setResourceFilename(sResourceFilename);
    }

    public CCLMessageFile(String sResourceFilename, String sResourceDirpath) {
        this(sResourceFilename);
        this._sResourceDirpath = sResourceDirpath;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("[CCLMessageFile: ");
        if (this._nLoadFrom == 2) {
            sb.append("load from bundle");
        } else {
            sb.append("file='").append(this._sResourceFilename).append("'");
        }
        sb.append("]");
        String sRet = sb.toString();
        return sRet;
    }

    protected void setResourceFilename(String sResourceFilename) {
        this._sResourceFilename = sResourceFilename;
        this._sResourceFilenamePrefix = sResourceFilename + "_";
    }

    protected String getResourceDirpath() {
        return this._sResourceDirpath;
    }

    @Override
    public void setLoggers(ICCLServiceAuditLogging logService, ICCLDebugLogging logDebug) {
        this._logDebug = logDebug;
        if (this._logDebug == null) {
            this._logDebug = CCLNullDebugLogger.getNullLogger();
        }
        this._logService = logService;
        if (this._logService == null) {
            this._logService = CCLNullServiceAuditLogger.getNullLogger();
        }
    }

    public void setAllowMissingFile(boolean b) {
        this._bAllowMissingFile = b;
    }

    @Override
    public void allowStringMarking(boolean b) {
        this._bAllowStringMarking = b;
    }

    @Override
    public boolean allowsStringMarking() {
        return this._bAllowStringMarking;
    }

    @Override
    public void prepare(ICCLResourceManager resmgr) {
        this._resmgr = resmgr;
    }

    public int getLoadFrom() {
        return this._nLoadFrom;
    }

    public void setLoadFrom(int nLoadFrom) {
        switch (nLoadFrom) {
            case 1: 
            case 2: 
            case 3: {
                this._nLoadFrom = nLoadFrom;
                break;
            }
            default: {
                throw new CCLRuntimeException("Invalid setting to load-from: " + nLoadFrom);
            }
        }
    }

    @Override
    public synchronized boolean needsReload(ICCLResourceToLoad res, CCLResource.LoadHandle hPreviousLoad) {
        long nPrevLastModified;
        File f;
        long nThisLastModified;
        boolean bRet = false;
        String sMsgsdkFilepath = hPreviousLoad.getDevelopmentResourceFilepath();
        if (sMsgsdkFilepath == null) {
            sMsgsdkFilepath = hPreviousLoad.getInstallResourceFilepath();
        }
        if (sMsgsdkFilepath != null && (nThisLastModified = (f = new File(sMsgsdkFilepath)).lastModified()) > (nPrevLastModified = hPreviousLoad.getLastModified())) {
            bRet = true;
        }
        return bRet;
    }

    protected String getDeveloperMsgFilepath(ICCLResourceToLoad res) {
        String sDeveloperMsgsdkFilepath = null;
        if (this._sResourceDirpath == null) {
            String sDeveloperMsgsdkDirpath = this._resmgr.getDeveloperMsgsdkDirpath();
            sDeveloperMsgsdkFilepath = this.getMessageFilepath(res.getLocale(), sDeveloperMsgsdkDirpath);
        }
        return sDeveloperMsgsdkFilepath;
    }

    protected String getInstallMsgFilepath(ICCLResourceToLoad res) {
        String sInstallMsgsdkFilepath = null;
        String sInstallMsgsdkDirpath = this._sResourceDirpath;
        if (sInstallMsgsdkDirpath == null) {
            sInstallMsgsdkDirpath = this._resmgr.getInstallMsgsdkDirpath();
        }
        sInstallMsgsdkFilepath = this.getMessageFilepath(res.getLocale(), sInstallMsgsdkDirpath);
        return sInstallMsgsdkFilepath;
    }

    @Override
    public synchronized CCLResource.LoadHandle loadIntoResource(ICCLResourceToLoad res, CCLResource.LoadHandle hPreviousLoad) {
        CCLResource.LoadHandle hRet = hPreviousLoad;
        if (hRet == null) {
            hRet = new CCLResource.LoadHandle(res.getLocale(), 0L);
        }
        boolean bLoadFromBundle = true;
        if (this._nLoadFrom == 3) {
            bLoadFromBundle = false;
        } else if (this._nLoadFrom == 1 && (this._resmgr.getDynamicResourceReloading() || this._resmgr.shouldLoadFromMsgsdk())) {
            bLoadFromBundle = false;
        }
        if (bLoadFromBundle) {
            this.loadFromBundle(res, hRet);
        } else {
            String sInstallMsgsdkDirpath;
            boolean bCopyToInstall = false;
            String sDeveloperMsgsdkDirpath = null;
            String sDeveloperMsgsdkFilepath = null;
            if (this._sResourceDirpath == null) {
                sDeveloperMsgsdkDirpath = this._resmgr.getDeveloperMsgsdkDirpath();
                sDeveloperMsgsdkFilepath = this.getDeveloperMsgFilepath(res);
            }
            if ((sInstallMsgsdkDirpath = this._sResourceDirpath) == null) {
                sInstallMsgsdkDirpath = this._resmgr.getInstallMsgsdkDirpath();
            }
            String sInstallMsgsdkFilepath = this.getInstallMsgFilepath(res);
            hRet.setDevelopmentResourceFilepath(sDeveloperMsgsdkFilepath);
            hRet.setInstallResourceFilepath(sInstallMsgsdkFilepath);
            if (sDeveloperMsgsdkFilepath != null && sInstallMsgsdkDirpath != null) {
                bCopyToInstall = true;
            }
            if (sInstallMsgsdkDirpath == null && sDeveloperMsgsdkDirpath == null) {
                throw new CCLRuntimeException("There is no msgsdk directory to load from");
            }
            String sMsgsdkFilepath = null;
            if (sDeveloperMsgsdkFilepath != null) {
                sMsgsdkFilepath = sDeveloperMsgsdkFilepath;
            } else if (sInstallMsgsdkFilepath != null) {
                sMsgsdkFilepath = sInstallMsgsdkFilepath;
            }
            if (sMsgsdkFilepath == null) {
                if (!this._bAllowMissingFile) {
                    throw new CCLRuntimeException("There is no msgsdk file to load from");
                }
            } else {
                this.loadFromMessageFile(sMsgsdkFilepath, res, hRet);
                File f = new File(sMsgsdkFilepath);
                long nLastModified = f.lastModified();
                hRet.setLastModified(nLastModified);
                if (bCopyToInstall) {
                    File fDev = new File(sDeveloperMsgsdkFilepath);
                    String sFilename = fDev.getName();
                    sInstallMsgsdkFilepath = sInstallMsgsdkDirpath + File.separator + sFilename;
                    CCLShellUtils.copyFile(sDeveloperMsgsdkFilepath, sInstallMsgsdkFilepath);
                }
            }
        }
        return hRet;
    }

    public static String normalizeLanguageForResourceBundle(String sLang_in) {
        String sLang_out = sLang_in;
        if (sLang_out.indexOf(95) > -1 || sLang_out.indexOf(45) > -1) {
            sLang_out = sLang_out.substring(0, 2) + "_" + sLang_out.substring(3).toUpperCase();
        }
        return sLang_out;
    }

    public static String normalizeLanguageForXMLFile(String sLang_in) {
        String sLang_out = sLang_in;
        if (sLang_out.indexOf(95) > -1 || sLang_out.indexOf(45) > -1) {
            sLang_out = sLang_out.substring(0, 2) + "-" + sLang_out.substring(3).toLowerCase();
        }
        return sLang_out;
    }

    protected String getMessageFilepath(Locale loc, String sDirpath) {
        String sRet = null;
        if (sDirpath != null) {
            File fDir = new File(sDirpath);
            if (!fDir.exists()) {
                throw new CCLRuntimeException("trying to load message file from non-existent directory '" + sDirpath + "'");
            }
            String[] vFilenames = fDir.list();
            List<String> vItems = Arrays.asList(vFilenames);
            String sMatch = CCLResourceManager.bestLocaleMatch(this._sResourceFilename, loc, vItems);
            if (sMatch != null) {
                sRet = CCLFileUtils.join(sDirpath, sMatch);
            }
        }
        return sRet;
    }

    protected void loadFromMessageFile(String sMessageFilepath, ICCLResourceToLoad res, CCLResource.LoadHandle hLoad) {
        try {
            HashMap mStrings = this.loadMessageFileStringMap(sMessageFilepath);
            this.loadFromMap(res, mStrings);
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "loading strings from file: '" + sMessageFilepath + "'");
        }
    }

    protected void loadFromInputStream(InputStream is, ICCLResourceToLoad res, CCLResource.LoadHandle hLoad) {
        try {
            HashMap mStrings = this.loadMessageFileStringMap(is);
            this.loadFromMap(res, mStrings);
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "loading strings from input stream");
        }
    }

    protected void loadFromMap(ICCLResourceToLoad res, Map mStrings) {
        for (CCLResource.ResourceString rs : mStrings.values()) {
            try {
                res.addString(rs);
            }
            catch (CCLResource.StringAlreadyPresentException sapex) {
            }
            catch (Exception ex) {
                throw new CCLRuntimeException(ex, "loading strings from map");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadFromBundle(ICCLResourceToLoad res, CCLResource.LoadHandle hLoad) {
        ResourceBundle bundle = null;
        Locale loc = res.getLocale();
        try {
            block8: {
                try {
                    bundle = loc != null ? ResourceBundle.getBundle(this._sResourceFilename, loc) : ResourceBundle.getBundle(this._sResourceFilename);
                }
                catch (MissingResourceException ex) {
                    if (this._bAllowMissingFile) break block8;
                    throw new CCLRuntimeException(ex, "loading resource bundle '" + this._sResourceFilename + "'");
                }
            }
            if (res == null || bundle == null) return;
            Enumeration<String> enumKeys = bundle.getKeys();
            while (enumKeys.hasMoreElements()) {
                String sKey = enumKeys.nextElement();
                String sValue = bundle.getString(sKey);
                CCLResource.ResourceString rs = new CCLResource.ResourceString();
                rs.parseCCLMessage(sKey, sValue);
                try {
                    res.addString(rs);
                }
                catch (CCLResource.StringAlreadyPresentException sapex) {
                }
                catch (Exception ex) {
                    throw new CCLRuntimeException(ex, "loading strings from resource bundles");
                    return;
                }
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "loading message strings from bundle '" + this._sResourceFilename + "'");
        }
    }

    protected ArrayList getLookupFilenames(Locale loc, String sFilename) {
        ArrayList<String> vRet = new ArrayList<String>();
        String sPath = null;
        String sLanguage = loc.getLanguage().toLowerCase();
        String sRegion = loc.getCountry().toLowerCase();
        if (sRegion.length() > 0) {
            sPath = sFilename + "_" + sLanguage + "_" + sRegion + ".xml";
            vRet.add(sPath);
        }
        sPath = sFilename + "_" + sLanguage + ".xml";
        vRet.add(sPath);
        sPath = sFilename + ".xml";
        vRet.add(sPath);
        return vRet;
    }

    protected static String normalizeMessageFilename(String sName) {
        String sRet = sName.toLowerCase();
        sRet = sRet.replace('-', '_');
        return sRet;
    }

    protected HashMap loadMessageFileStringMap(String sFilepath) {
        HashMap mStrings = null;
        CCLResourceLoader ldr = new CCLResourceLoader(this._logService, this._logDebug);
        mStrings = ldr.loadResourceStringMapFromCCLMessageFile(sFilepath);
        return mStrings;
    }

    protected HashMap loadMessageFileStringMap(InputStream is) {
        HashMap mStrings = null;
        CCLResourceLoader ldr = new CCLResourceLoader(this._logService, this._logDebug);
        mStrings = ldr.loadResourceStringMapFromCCLMessageFile(is);
        return mStrings;
    }
}

