/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.resource;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.html.CCLHTMLEntities;
import com.cognos.ccl4j.logging.ICCLDebugLogging;
import com.cognos.ccl4j.logging.ICCLLoggable;
import com.cognos.ccl4j.logging.ICCLServiceAuditLogging;
import com.cognos.ccl4j.message.CCLMsg;
import com.cognos.ccl4j.message.CCLMsgInfo;
import com.cognos.ccl4j.message.CCLMsgParam;
import com.cognos.ccl4j.resource.CCLCodeList;
import com.cognos.ccl4j.resource.ICCLResourceLoader;
import com.cognos.ccl4j.resource.ICCLResourceManager;
import com.cognos.ccl4j.resource.ICCLResourceToLoad;
import com.cognos.ccl4j.util.CCLCollectionUtils;
import com.cognos.ccl4j.util.CCLStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class CCLResource
implements ICCLResourceToLoad,
ICCLLoggable {
    public static final String DEFAULT_LANGUAGE = "en";
    public static final String DEFAULT_MSG_SEPARATOR = " -- ";
    public static final int TEXT_MESSAGE = 1;
    public static final int HTML_MESSAGE = 2;
    public static final int IS_SYSTEM = 1;
    public static final int IS_CLIENT = 2;
    public static final int PSEUDO_LENGTHEN = 1;
    public static final int PSEUDO_UMLAUTS = 2;
    private ICCLServiceAuditLogging _logService = null;
    private HashMap _mResourceStrings_DontUseDirectly = new HashMap(1017);
    private HashMap _mProperties = new HashMap(107);
    private String _sLanguageCode = null;
    private ICCLResourceManager _resMgrLoadedBy = null;
    private Locale _locale = null;
    private HashMap _mLoaderToHandle = new HashMap();
    private static boolean _bUserDefinedMark = false;
    private static String _sUserDefinedMark = null;
    private static boolean _bMarkStringResources = false;
    private static String _sStringResourceMark = null;
    private static String _sMissingStringResourceMark = "BAD:";
    private static boolean _bPrefixForeignResources = false;
    private static boolean _bPseudoTranslate = false;
    private static int _nPseudoTranslateFlags = 0;
    private static boolean _bPseudoTranslate_DoLengthen = false;
    private static boolean _bPseudoTranslate_DoUmlauts = false;
    private static boolean _bSuffixResourceId = false;
    private static final String _sCJKLanguages = "/zs/ja/ko";

    LoadHandle getHandleForLoader(ICCLResourceLoader ldr) {
        LoadHandle hRet = (LoadHandle)this._mLoaderToHandle.get(ldr);
        return hRet;
    }

    void setHandleForLoader(ICCLResourceLoader ldr, LoadHandle h) {
        this._mLoaderToHandle.put(ldr, h);
    }

    public static void setDebug_UserDefinedStringMark(boolean bDoStringMarking, String sUserDefinedMark) {
        _bUserDefinedMark = bDoStringMarking;
        _sUserDefinedMark = sUserDefinedMark;
    }

    public static void setDebug_MarkStringResources(boolean bDoStringMarking, String sStringPrefixMark) {
        _bMarkStringResources = bDoStringMarking;
        _sStringResourceMark = sStringPrefixMark;
    }

    public static void setMissingStringPrefix(String sMissingStringPrefix) {
        _sMissingStringResourceMark = sMissingStringPrefix;
    }

    public static void setDebug_LocalizationAssistance_PrefixForeignResources(boolean bPrefixForeignResources) {
        _bPrefixForeignResources = bPrefixForeignResources;
    }

    public static void setDebug_LocalizationAssistance_PseudoTranslateResources(boolean bTranslate, int flags) {
        _bPseudoTranslate = bTranslate;
        _nPseudoTranslateFlags = flags;
        _bPseudoTranslate_DoLengthen = (_nPseudoTranslateFlags & 1) != 0;
        _bPseudoTranslate_DoUmlauts = (_nPseudoTranslateFlags & 2) != 0;
    }

    public static void setDebug_LocalizationAssistance_SuffixStringsWithResourceId(boolean bSuffixStringsWIthResourceId) {
        _bSuffixResourceId = bSuffixStringsWIthResourceId;
    }

    public CCLResource(String sLanguageCode, Locale locale, ICCLResourceManager resMgr) {
        this._sLanguageCode = sLanguageCode;
        this._locale = locale;
        this._resMgrLoadedBy = resMgr;
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    public String getLanguageCode() {
        return this._sLanguageCode;
    }

    @Override
    public void setLoggers(ICCLServiceAuditLogging logService, ICCLDebugLogging logDebug) {
        this._logService = logService;
    }

    public boolean isCJKLanguage() {
        boolean bRet = false;
        String sLang = this._sLanguageCode.toLowerCase();
        if (_sCJKLanguages.indexOf(sLang) > -1) {
            bRet = true;
        }
        return bRet;
    }

    @Override
    public ICCLResourceManager getResourceManager() {
        return this._resMgrLoadedBy;
    }

    @Override
    public synchronized void setProperty(String sName, Object value) {
        this._mProperties.put(sName, value);
    }

    @Override
    public Object getProperty(String sName) {
        return this._mProperties.get(sName);
    }

    public CCLCodeList getCodeList(String sName) {
        return (CCLCodeList)this.getProperty(sName);
    }

    public String getCodeText(String sCodeListName, String sCode) {
        CCLCodeList cl = this.getCodeList(sCodeListName);
        return cl.getText(sCode);
    }

    public String getCodeImage(String sCodeListName, String sCode) {
        CCLCodeList cl = this.getCodeList(sCodeListName);
        return cl.getImage(sCode);
    }

    HashMap getProperties() {
        return this._mProperties;
    }

    HashMap getResourceStrings() {
        return this._mResourceStrings_DontUseDirectly;
    }

    @Override
    public void addString(ResourceString rs) throws StringAlreadyPresentException {
        String sMsgId = rs._sId;
        if (this.getResourceStrings().containsKey(sMsgId)) {
            throw new StringAlreadyPresentException("key already in resource: '" + sMsgId + "'");
        }
        this.getResourceStrings().put(sMsgId, rs);
    }

    @Override
    public void replaceString(ResourceString rs) {
        String sMsgId = rs._sId;
        this.getResourceStrings().put(sMsgId, rs);
    }

    public Iterator getIterator() {
        Iterator iterRet = this._mResourceStrings_DontUseDirectly.keySet().iterator();
        return iterRet;
    }

    public ResourceString getResourceString(String sMsgCode) {
        ResourceString rs = (ResourceString)this._mResourceStrings_DontUseDirectly.get(sMsgCode);
        return rs;
    }

    @Override
    public ResourceString getString(String sMsgCode) {
        ResourceString rs = (ResourceString)this._mResourceStrings_DontUseDirectly.get(sMsgCode);
        return rs;
    }

    public String getMessageNumber(String sMsgCode) {
        String sRet = null;
        ResourceString rs = this.getResourceString(sMsgCode);
        if (rs != null) {
            sRet = rs.getCRNMessageCode();
        }
        return sRet;
    }

    public boolean hasResourceId(String sResId) {
        boolean bRet = this._mResourceStrings_DontUseDirectly.containsKey(sResId);
        return bRet;
    }

    public byte[] getBA(String sMsgCode) {
        byte[] baRet = null;
        ResourceString rs = this.getResourceString(sMsgCode);
        if (rs == null) {
            String sRet = _sMissingStringResourceMark + sMsgCode;
            baRet = CCLStringUtils.String2UTF8ByteArray(sRet);
        } else {
            baRet = rs.getStringBA();
        }
        return baRet;
    }

    @Override
    public String get(String sMsgCode) {
        List vParams = null;
        String sValue = this._getString(sMsgCode, vParams, 1);
        return sValue;
    }

    public String get(String sMsgCode, int nType) {
        List vParams = null;
        String sValue = this._getString(sMsgCode, vParams, nType);
        return sValue;
    }

    public String get(String sMsgCode, CCLMsgParam[] aParams) {
        String sRet = null;
        List<CCLMsgParam> vParams = null;
        if (aParams != null) {
            vParams = Arrays.asList(aParams);
        }
        sRet = this._getString(sMsgCode, vParams, 1);
        return sRet;
    }

    public String get(String sMsgCode, CCLMsgParam param1) {
        String sRet = null;
        ArrayList<CCLMsgParam> vParams = new ArrayList<CCLMsgParam>();
        if (param1 != null) {
            vParams.add(param1);
        }
        sRet = this._getString(sMsgCode, vParams, 1);
        return sRet;
    }

    public String get(String sMsgCode, CCLMsgParam param1, CCLMsgParam param2) {
        String sRet = null;
        ArrayList<CCLMsgParam> vParams = new ArrayList<CCLMsgParam>();
        if (param1 != null) {
            vParams.add(param1);
        }
        if (param2 != null) {
            vParams.add(param2);
        }
        sRet = this._getString(sMsgCode, vParams, 1);
        return sRet;
    }

    public String get(int errorCode) {
        return "CMM-" + errorCode + ": " + this.get("error." + errorCode);
    }

    public ArrayList getStrings(CCLMsgInfo mi) {
        return this.getStrings(mi, 1);
    }

    public ArrayList getStrings(CCLMsgInfo mi, int nType) {
        return this.getStrings(mi, nType, 2);
    }

    public ArrayList getStrings(CCLMsgInfo mi, int nType, int typeSelectionFlags) {
        ArrayList vMsgs;
        ArrayList<String> vStrings = new ArrayList<String>();
        if (mi != null && (vMsgs = mi.getMessages()) != null) {
            for (int i = vMsgs.size() - 1; i >= 0; --i) {
                String sText;
                CCLMsg msg = (CCLMsg)vMsgs.get(i);
                if (((typeSelectionFlags & 2) == 0 || !msg.isClientMessage() || msg.isTextMessage() && !msg.isPresentableMessage()) && ((typeSelectionFlags & 1) == 0 || !msg.isSystemMessage()) && ((typeSelectionFlags & 1) == 0 || !msg.isTextMessage())) continue;
                if (msg.isTextMessage()) {
                    sText = msg.getText();
                    if (nType == 2) {
                        sText = CCLResource.resolveHTMLMarkup(sText);
                    }
                    vStrings.add(sText);
                    continue;
                }
                sText = this.get(msg, nType);
                vStrings.add(sText);
            }
        }
        return vStrings;
    }

    public String get(CCLMsgInfo mi) {
        String sRet = this.get(mi, DEFAULT_MSG_SEPARATOR, 1);
        return sRet;
    }

    public String get(CCLMsgInfo mi, String sSep) {
        return this.get(mi, sSep, 1);
    }

    public String get(CCLMsgInfo mi, String sSeparator_param, int nType) {
        ArrayList vStrings;
        String sRet = null;
        String sSeparator = sSeparator_param;
        if (sSeparator == null) {
            sSeparator = DEFAULT_MSG_SEPARATOR;
        }
        if ((vStrings = this.getStrings(mi, 1)) != null && vStrings.size() > 0) {
            StringBuffer sb = new StringBuffer(1024);
            int nLen = vStrings.size();
            for (int i = 0; i < nLen; ++i) {
                String sMsg = (String)vStrings.get(i);
                sb.append(sMsg);
                if (i >= nLen - 1) continue;
                sb.append(sSeparator);
            }
            sRet = sb.toString();
        }
        if (nType == 2) {
            sRet = CCLResource.resolveHTMLMarkup(sRet);
        }
        return sRet;
    }

    public String get(CCLMsg msg) {
        return this.get(msg, 1);
    }

    public String get(CCLMsg msg, int nType) {
        String sMsgCode = msg.getMsgCode();
        ArrayList vParams = msg.getParams();
        return this._getString(sMsgCode, vParams, nType);
    }

    public String getString_unmarked(String sMsgCode) {
        String sRet = null;
        ResourceString rs = this.getResourceString(sMsgCode);
        if (rs != null) {
            sRet = rs.getString_unmarked();
        }
        return sRet;
    }

    private String _getString(String sMsgCode, List vParams, int nType) {
        String sRet = null;
        String sResString = null;
        try {
            if (sMsgCode == null) {
                sRet = "BAD:<null>-key";
            } else {
                ResourceString rs = this.getResourceString(sMsgCode);
                if (rs == null) {
                    sRet = _sMissingStringResourceMark + sMsgCode;
                } else {
                    sResString = rs._sString;
                    if (vParams == null || vParams.size() == 0) {
                        sRet = sResString;
                    } else {
                        int nMax = vParams.size();
                        HashMap<String, CCLMsgParam> mParams = new HashMap<String, CCLMsgParam>(nMax * 2);
                        for (int i = 0; i < nMax; ++i) {
                            CCLMsgParam p = (CCLMsgParam)vParams.get(i);
                            String sName = p.getName();
                            mParams.put(sName, p);
                        }
                        StringBuffer sbOutput = null;
                        String sIn = sResString;
                        sbOutput = new StringBuffer(512);
                        int nInputLen = sIn.length();
                        for (int nInputIdxChar = 0; nInputIdxChar < nInputLen; ++nInputIdxChar) {
                            char chText = sIn.charAt(nInputIdxChar);
                            if (chText != '{') {
                                sbOutput.append(chText);
                                continue;
                            }
                            StringBuffer sbParamName = new StringBuffer(50);
                            boolean bHaveAName = false;
                            ++nInputIdxChar;
                            while (nInputIdxChar < nInputLen) {
                                char chParamName = sIn.charAt(nInputIdxChar);
                                if (chParamName == '}') {
                                    bHaveAName = true;
                                    break;
                                }
                                sbParamName.append(chParamName);
                                ++nInputIdxChar;
                            }
                            if (!bHaveAName) break;
                            String sParamName = sbParamName.toString();
                            CCLMsgParam param = (CCLMsgParam)mParams.get(sParamName);
                            if (param == null) {
                                sbOutput.append("***ERROR: no resource '").append(sParamName).append("'***");
                                continue;
                            }
                            String sParamValue = null;
                            if (param.valueIsText()) {
                                sParamValue = param.getValueAsString(this._locale);
                            } else {
                                sParamValue = this.get(param.getValueAsString(this._locale));
                                if (sParamValue == null) {
                                    // empty if block
                                }
                            }
                            if (sParamValue == null) continue;
                            sbOutput.append(sParamValue);
                        }
                        sRet = sbOutput.toString();
                    }
                }
            }
            if (nType == 2) {
                sRet = CCLResource.resolveHTMLMarkup(sRet);
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "translating msg code=" + sMsgCode + " text='" + sResString + "'");
        }
        return sRet;
    }

    public static String stripMessageCode(String sMessageNumber, String sMessage) {
        if (sMessage == null || sMessageNumber == null) {
            return sMessage;
        }
        String sMessageReturn = sMessage;
        String sMessagePrefix = null;
        if (_bMarkStringResources && sMessage.startsWith(_sStringResourceMark)) {
            if (sMessage.charAt(_sStringResourceMark.length() + 2) == ':') {
                sMessagePrefix = sMessage.substring(0, _sStringResourceMark.length() + 3);
                sMessage = sMessage.substring(_sStringResourceMark.length() + 3);
            } else {
                sMessagePrefix = _sStringResourceMark;
                sMessage = sMessage.substring(1);
            }
        }
        if (sMessage != null && sMessage.startsWith(sMessageNumber)) {
            sMessageReturn = sMessage.substring(sMessageNumber.length() + 1);
            if (sMessagePrefix != null) {
                sMessageReturn = sMessagePrefix + sMessageReturn;
            }
        }
        return sMessageReturn;
    }

    public void resolveVariables() {
        try {
            HashMap mProps = this.getResourceStrings();
            Set setEntries = mProps.entrySet();
            for (Map.Entry entry : setEntries) {
                ResourceString rs = (ResourceString)entry.getValue();
                rs._nResolvedStatus = 1;
            }
            Set setKeys = mProps.keySet();
            ArrayList vKeys = CCLCollectionUtils.getSortedList(setKeys);
            for (String sKey : vKeys) {
                Object sValue = null;
                Object sValueWithReplacements = null;
                try {
                    ResourceString resString = (ResourceString)mProps.get(sKey);
                    this.resolveResString(resString);
                }
                catch (Exception ex) {
                    this._logService.errorText("problem when resolving load-time variables", ex);
                }
            }
        }
        catch (Exception ex) {
            throw new CCLRuntimeException(ex, "resolving loadtime variables");
        }
    }

    private void resolveResString(ResourceString resString) {
        String sValue = resString.getString();
        String sValueWithReplacements = this.replaceVariables(sValue);
        resString.setString(sValueWithReplacements);
    }

    private String markString(String sIn, String sMarker, boolean bPendingChange, String sMsgCode) {
        String sOut = sIn;
        if (sMarker == null) {
            sMarker = _sStringResourceMark;
        }
        if (_bPrefixForeignResources && !this._sLanguageCode.equalsIgnoreCase(DEFAULT_LANGUAGE)) {
            sOut = this._sLanguageCode + ":" + sOut;
        }
        if (bPendingChange) {
            sOut = "*" + sOut;
        }
        if (_bMarkStringResources) {
            sOut = sMarker + sOut;
        }
        if (_bPseudoTranslate) {
            sOut = this.pseudoTranslate(sOut);
        }
        if (_bUserDefinedMark) {
            sOut = sOut + _sUserDefinedMark;
        }
        if (_bSuffixResourceId) {
            sOut = sOut + DEFAULT_MSG_SEPARATOR;
            sOut = sOut + sMsgCode;
        }
        return sOut;
    }

    static String replaceMarker(String sIn, String sMarker) {
        String sRet = sIn;
        if (_sStringResourceMark != null && sIn != null && sIn.length() > 0 && sIn.startsWith(_sStringResourceMark)) {
            sRet = sMarker + sIn.substring(_sStringResourceMark.length());
        }
        return sRet;
    }

    private void markString(ResourceString resStr) {
        String sMsgCode = resStr.getId();
        String sString = resStr._sString;
        resStr._sString_unmarked = sString;
        ResourceString.access$402(resStr, null);
        if (sString != null) {
            sString = this.markString(sString, _sStringResourceMark, resStr._bNotYetLocalized, sMsgCode);
            resStr._sString = sString;
        }
    }

    void markStrings() {
        Iterator iter = this.getIterator();
        while (iter.hasNext()) {
            String sId = (String)iter.next();
            ResourceString resStr = this.getResourceString(sId);
            this.markString(resStr);
        }
    }

    public String replaceVariables(String sIn) {
        String sRet = this.replaceVariablesOrReturnNull(sIn);
        if (sRet == null) {
            sRet = sIn;
        }
        return sRet;
    }

    public String replaceVariables(String sIn, boolean bDoubleAnySingleQuotes, String sMarker) {
        String sRet = this.replaceVariablesOrReturnNull(sIn, bDoubleAnySingleQuotes, sMarker);
        if (sRet == null) {
            sRet = sIn;
        }
        return sRet;
    }

    public String replaceVariablesOrReturnNull(String sIn) {
        return this.replaceVariablesOrReturnNull(sIn, false, null);
    }

    public String replaceVariablesOrReturnNull(String sIn, boolean bDoubleAnySingleQuotes, String sMarker) {
        String sOut;
        block26: {
            sOut = null;
            if (sIn != null && sIn.length() > 0) {
                try {
                    int nVariableStart = -1;
                    int nIdx_start = 0;
                    int nIdx_param_start = -1;
                    nIdx_param_start = sIn.indexOf("${", nIdx_start);
                    if (nIdx_param_start <= -1) break block26;
                    StringBuffer sb = new StringBuffer(sIn.length() * 2);
                    while (true) {
                        block27: {
                            if (nIdx_param_start == -1) {
                                sb.append(sIn.substring(nIdx_start));
                                break;
                            }
                            int nIdx_param_end = sIn.indexOf(125, nIdx_param_start);
                            if (nIdx_param_end == -1) {
                                this.reportLoadtimeError("Missing closing } in string='" + sIn);
                                break;
                            }
                            String sPrefix = sIn.substring(nIdx_start, nIdx_param_start);
                            sb.append(sPrefix);
                            nVariableStart = nIdx_param_start;
                            nIdx_start = nIdx_param_end + 1;
                            String sParamKey = sIn.substring(nIdx_param_start + 2, nIdx_param_end);
                            try {
                                char ch;
                                if (sParamKey.charAt(0) == 'u' && sParamKey.length() == 5) {
                                    String sUniChar = sParamKey.substring(1);
                                    ch = (char)Integer.parseInt(sUniChar, 16);
                                    sb.append(ch);
                                    break block27;
                                }
                                ResourceString resString = this.getResourceString(sParamKey);
                                if (resString != null) {
                                    if (resString._nResolvedStatus != 3 && resString._nResolvedStatus != 4) {
                                        if (resString._nResolvedStatus == 2) {
                                            throw new UnresolvedVariableException("variable '" + sParamKey + "' has a circular reference to other variables");
                                        }
                                        if (resString._nResolvedStatus == 1) {
                                            try {
                                                resString._nResolvedStatus = 2;
                                                this.resolveResString(resString);
                                            }
                                            catch (Exception ex) {
                                                resString._nResolvedStatus = 4;
                                                throw ex;
                                            }
                                            finally {
                                                if (resString._nResolvedStatus != 4) {
                                                    resString._nResolvedStatus = 3;
                                                }
                                            }
                                        } else {
                                            throw new CCLRuntimeException("invalid resolve-status='" + resString._nResolvedStatus);
                                        }
                                    }
                                    String sNewValue = resString.getString();
                                    sNewValue = sNewValue.trim();
                                    if (sMarker != null) {
                                        sNewValue = CCLResource.replaceMarker(sNewValue, sMarker);
                                    }
                                    if (bDoubleAnySingleQuotes) {
                                        sNewValue = CCLStringUtils.replaceAll(sNewValue, "'", "''");
                                    }
                                    if (sNewValue != null) {
                                        sb.append(sNewValue);
                                    }
                                    break block27;
                                }
                                ch = '\u0000';
                                try {
                                    ch = CCLHTMLEntities.getCharForHTMLEntity(sParamKey);
                                    sb.append(ch);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                if (ch == '\u0000') {
                                    this.reportLoadtimeError("Did not find value for resource id='" + sParamKey + "' substituted into string='" + sIn + "'" + " for language code='" + this._sLanguageCode + "'");
                                }
                            }
                            catch (Exception ex) {
                                throw new CCLRuntimeException(ex, "substituting variable '" + sParamKey + "' at char " + nVariableStart + " value='" + sIn + "'");
                            }
                        }
                        nIdx_param_start = sIn.indexOf("${", nIdx_start);
                    }
                    sOut = sb.toString();
                }
                catch (Exception ex) {
                    throw new CCLRuntimeException(ex, "replacing variables in string=" + sIn);
                }
            }
        }
        return sOut;
    }

    public static String resolveHTMLMarkup(String sIn) {
        String sRet = sIn;
        int nLen = 0;
        if (sIn != null) {
            nLen = sIn.length();
            if (sIn.length() > 0) {
                char chThis = '\u0000';
                char chNext = '\u0000';
                int nLenMinusOne = nLen - 1;
                StringBuffer sb = new StringBuffer(nLen);
                for (int i = 0; i < nLen; ++i) {
                    chThis = sIn.charAt(i);
                    chNext = i < nLenMinusOne ? sIn.charAt(i + 1) : (char)'\u0000';
                    if (chThis == '\\') {
                        sb.append(chNext);
                        ++i;
                        continue;
                    }
                    if (chThis == '[') {
                        sb.append('<');
                        continue;
                    }
                    if (chThis == ']') {
                        sb.append('>');
                        continue;
                    }
                    sb.append(chThis);
                }
                sRet = sb.toString();
            }
        }
        return sRet;
    }

    private String pseudoTranslate(String sIn) {
        String sOut = sIn;
        if (sIn != null) {
            int nOrigLen;
            int chEmDash = 8212;
            int chComplicatedChinese = 40806;
            int chOpen = 40;
            int chClose = 41;
            int chPad = 8212;
            int nNewLen = nOrigLen = sIn.length();
            if (_bPseudoTranslate_DoLengthen) {
                nNewLen = (int)((double)nOrigLen * 1.4);
            }
            StringBuffer sb = new StringBuffer(nNewLen * 2);
            if (_bPseudoTranslate_DoLengthen) {
                sb.append('(');
                sb.append('\u2014');
            }
            boolean bFlushing = false;
            int nLen = sIn.length();
            for (int nIdx = 0; nIdx < nLen; ++nIdx) {
                int ch = sIn.charAt(nIdx);
                if (_bPseudoTranslate_DoUmlauts) {
                    if (ch == 123) {
                        bFlushing = true;
                    } else if (bFlushing && ch == 125) {
                        bFlushing = false;
                    }
                    if (!bFlushing) {
                        switch (ch) {
                            case 65: {
                                ch = 197;
                                break;
                            }
                            case 69: {
                                ch = 203;
                                break;
                            }
                            case 73: {
                                ch = 207;
                                break;
                            }
                            case 79: {
                                ch = 214;
                                break;
                            }
                            case 85: {
                                ch = 220;
                                break;
                            }
                            case 97: {
                                ch = 228;
                                break;
                            }
                            case 101: {
                                ch = 235;
                                break;
                            }
                            case 105: {
                                ch = 239;
                                break;
                            }
                            case 111: {
                                ch = 246;
                                break;
                            }
                            case 117: {
                                ch = 252;
                            }
                        }
                    }
                }
                sb.append((char)ch);
            }
            if (_bPseudoTranslate_DoLengthen) {
                while (sb.length() < nNewLen - 1) {
                    sb.append('\u2014');
                }
                sb.append('\u2014');
                sb.append('\u9f66');
                sb.append(')');
            }
            sOut = sb.toString();
        }
        return sOut;
    }

    private void reportLoadtimeError(String sMsg) {
        if (this._logService != null) {
            this._logService.errorText("Resource loader: ERROR: " + sMsg);
        } else {
            String sMarkerLine = "=======================================================";
            System.err.println("=======================================================");
            System.err.println("=======================================================");
            System.err.println("=======================================================");
            System.err.println("Resource loader: ERROR: " + sMsg);
            System.err.println("=======================================================");
            System.err.println("=======================================================");
            System.err.println("=======================================================");
        }
    }

    public static final class ResourceString {
        private boolean _bNotYetLocalized = false;
        private String _sId;
        private String _sString;
        private byte[] _baString;
        private String _sString_unmarked;
        private byte[] _baString_unmarked;
        private int _nErrorCode;
        private String _sCRNMessageCode;
        static final int NOT_RESOLVED = 1;
        static final int BEING_RESOLVED = 2;
        static final int RESOLVED = 3;
        static final int RESOLVE_ERROR = 4;
        int _nResolvedStatus = 1;

        void parseCCLMessage(String sKey, String sValue) {
            this._sId = sKey;
            ResourceString.parseCCLMessageIntoResourceString(sValue, this);
        }

        static void parseCCLMessageIntoResourceString(String sMessageString, ResourceString rs) {
            boolean bMsgHasPrefix = false;
            String sMsgCode = null;
            String sMessage = null;
            int nErrorCode = 0;
            if (sMessageString != null) {
                int nIdx_space = sMessageString.indexOf(32);
                int nIdx_dash_1 = -1;
                int nIdx_dash_2 = -1;
                String sFirstToken = null;
                if (nIdx_space > 4) {
                    sFirstToken = sMessageString.substring(0, nIdx_space);
                    nIdx_dash_1 = sFirstToken.indexOf(45);
                    nIdx_dash_2 = -1;
                    if (nIdx_dash_1 > -1) {
                        nIdx_dash_2 = sFirstToken.indexOf(45, nIdx_dash_1 + 1);
                    }
                }
                if (nIdx_dash_1 > -1 && nIdx_dash_2 > -1) {
                    nErrorCode = -1;
                    String sErrorCode = sFirstToken.substring(nIdx_dash_2 + 1);
                    try {
                        nErrorCode = Integer.parseInt(sErrorCode);
                        sMsgCode = sFirstToken;
                        sMessage = sMessageString;
                        bMsgHasPrefix = true;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
            }
            if (bMsgHasPrefix) {
                rs._sCRNMessageCode = sMsgCode;
                rs._sString = sMessage;
                rs._nErrorCode = nErrorCode;
            } else {
                rs._sString = sMessageString;
            }
        }

        int getErrorCode() {
            return this._nErrorCode;
        }

        void setErrorCode(int errorCode) {
            this._nErrorCode = errorCode;
        }

        public String getCRNMessageCode() {
            return this._sCRNMessageCode;
        }

        void setCRNMessageCode(String messageCode) {
            this._sCRNMessageCode = messageCode;
        }

        String getId() {
            return this._sId;
        }

        public void setId(String id) {
            this._sId = id;
        }

        public String getString() {
            return this._sString;
        }

        byte[] getStringBA() {
            return this._baString;
        }

        public String getString_unmarked() {
            String sRet = this._sString_unmarked;
            if (sRet == null) {
                sRet = this._sString;
            }
            return sRet;
        }

        byte[] getStringBA_unmarked() {
            if (this._baString_unmarked == null && this._sString_unmarked != null) {
                this._baString_unmarked = CCLStringUtils.String2UTF8ByteArray(this._sString_unmarked);
            }
            byte[] baRet = this._baString_unmarked;
            return baRet;
        }

        public void setString(String string) {
            this._sString = string == null ? "" : string;
            this._baString = CCLStringUtils.String2UTF8ByteArray(this._sString);
        }

        void setNotYetLocalized(boolean b) {
            this._bNotYetLocalized = b;
        }

        boolean isNotYetLocalized() {
            return this._bNotYetLocalized;
        }

        static /* synthetic */ byte[] access$402(ResourceString x0, byte[] x1) {
            x0._baString_unmarked = x1;
            return x1;
        }
    }

    final class UnresolvedVariableException
    extends CCLRuntimeException {
        UnresolvedVariableException(String sMsg) {
            super(sMsg);
        }
    }

    final class CCLResourceAsMap
    extends CCLStringUtils.ExtendedVariablesReplacementMap {
        final CCLResource _res;
        final HashMap _map;

        CCLResourceAsMap(CCLResource res) {
            super(res._mResourceStrings_DontUseDirectly);
            this._res = res;
            this._map = this._res._mResourceStrings_DontUseDirectly;
        }

        @Override
        public Object get(Object key) {
            String sRet = null;
            String sKey = (String)key;
            sRet = this._res.get(sKey);
            if (sRet == null) {
                sRet = CCLStringUtils.getExtendedVariable(sKey);
            }
            return sRet;
        }
    }

    public static class LoadHandle {
        protected Locale _locale = null;
        protected long _nLastLoadedTimestamp = 0L;
        protected boolean _bDevelopementResourceFilepathSet = false;
        protected String _sDevelopmentResourceFilepath = null;
        protected boolean _bInstallResourceFilepathSet = false;
        protected String _sInstallResourceFilepath = null;

        public LoadHandle(Locale loc, long nLastLoadedTimestamp) {
            this._locale = loc;
            this._nLastLoadedTimestamp = nLastLoadedTimestamp;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(500);
            sb.append("[LoadHandle:");
            if (this._locale != null) {
                sb.append(" locale=").append(this._locale.getDisplayName());
            }
            if (this._nLastLoadedTimestamp != 0L) {
                sb.append(" last-loaded=").append(this._nLastLoadedTimestamp);
            }
            if (this._sDevelopmentResourceFilepath != null) {
                sb.append(" dev='").append(this._sDevelopmentResourceFilepath).append("'");
            }
            if (this._sInstallResourceFilepath != null) {
                sb.append(" inst='").append(this._sInstallResourceFilepath).append("'");
            }
            sb.append("]");
            String sRet = sb.toString();
            return sRet;
        }

        public Locale getLocale() {
            return this._locale;
        }

        public long getLastModified() {
            return this._nLastLoadedTimestamp;
        }

        public void setLastModified(long nTimestamp) {
            this._nLastLoadedTimestamp = nTimestamp;
        }

        public void setDevelopmentResourceFilepath(String s) {
            this._sDevelopmentResourceFilepath = s;
            this._bDevelopementResourceFilepathSet = true;
        }

        public String getDevelopmentResourceFilepath() {
            return this._sDevelopmentResourceFilepath;
        }

        public boolean hasDeveloperResourceFilepathBeenSet() {
            return this._bDevelopementResourceFilepathSet;
        }

        public void setInstallResourceFilepath(String s) {
            this._sInstallResourceFilepath = s;
            this._bInstallResourceFilepathSet = true;
        }

        public boolean hasInstallResourceFilepathBeenSet() {
            return this._bInstallResourceFilepathSet;
        }

        public String getInstallResourceFilepath() {
            return this._sInstallResourceFilepath;
        }
    }

    public static class StringAlreadyPresentException
    extends CCLRuntimeException {
        static final long serialVersionUID = -7060263873633013110L;

        StringAlreadyPresentException(String sMsg) {
            super(sMsg);
        }
    }
}

