/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccl4j.util;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class CCLCollectionUtils {
    private CCLCollectionUtils() {
    }

    public static Collection collectionFromIterator(Iterator iter) {
        return CCLCollectionUtils.collectionFromIterator(iter, null);
    }

    public static ArrayList arrayListFromIterator(Iterator iter) {
        return (ArrayList)CCLCollectionUtils.collectionFromIterator(iter, null);
    }

    public static Collection collectionFromIterator(Iterator iter, Class clsNewColl) {
        Collection collRet = null;
        if (clsNewColl != null) {
            try {
                collRet = (Collection)clsNewColl.newInstance();
            }
            catch (Exception iex) {
                throw new CCLRuntimeException(iex, "creating instance of class '" + clsNewColl.getName() + "'");
            }
        } else {
            collRet = new ArrayList();
        }
        if (iter != null) {
            while (iter.hasNext()) {
                Object obj = iter.next();
                collRet.add(obj);
            }
        }
        return collRet;
    }

    public static ArrayList getSortedList(Collection coll) {
        ArrayList vSorted = null;
        if (coll != null) {
            TreeSet setStrings = new TreeSet(coll);
            vSorted = new ArrayList(setStrings);
        } else {
            vSorted = new ArrayList();
        }
        return vSorted;
    }
}

