/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.IPFTest;

import com.cognos.IPFTest.IPFTest;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTaskPrompt;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.helpers.LogLog;

public class IPFDbConnTask
implements ICnfgTask {
    private static final String LOGIN_ENTRY_NAME = "login.entry.name";
    private static final String PROP_PASSWORD = "password";
    private static final String PROP_USER = "user";
    protected String m_dbUser = "";
    protected String m_dbPassword = "";
    protected String m_dbName = "";
    protected String m_dbDriver = "";
    protected String loginEntryName = "";
    protected Properties advancedProperties;
    boolean m_driverLoaded = false;
    protected int m_dbType = 0;
    protected String m_dbURL = "";
    protected String m_dbInstanceName = "";
    protected Connection m_dbConn = null;

    public String getDBUser() {
        return this.m_dbUser;
    }

    public String getDBPassword() {
        return this.m_dbPassword;
    }

    public String getDBName() {
        return this.m_dbName;
    }

    public String getDBInstanceName() {
        return this.m_dbInstanceName;
    }

    public String getDBDriver() {
        return this.m_dbDriver;
    }

    public int getDBType() {
        return this.m_dbType;
    }

    public String getDBURL() {
        return this.m_dbURL;
    }

    protected void setDBUser(String param) {
        this.m_dbUser = param;
    }

    protected void setDBPassword(String param) {
        this.m_dbPassword = param;
    }

    protected void setDBName(String param) {
        this.m_dbName = param;
    }

    protected void setDBInstanceName(String param) {
        this.m_dbInstanceName = param;
    }

    protected void setDBDriver(String param) {
        this.m_dbDriver = param;
    }

    protected void setDBType(int param) {
        this.m_dbType = param;
    }

    protected void setDBURL(String param) {
        this.m_dbURL = param;
    }

    public void setLoginEntryName(String loginEntryName) {
        this.loginEntryName = loginEntryName;
    }

    public void setAdvancedProperties(Properties advancedProperties) {
        this.advancedProperties = advancedProperties;
    }

    public String getLabel() {
        return IPFTest.m_taskLabel;
    }

    public String getDescription() {
        if (2 == this.m_dbType || 7 == this.m_dbType) {
            return IPFTest.m_taskDscr[0];
        }
        if (1 == this.m_dbType || 4 == this.m_dbType || 9 == this.m_dbType) {
            return IPFTest.m_taskDscr[2];
        }
        if (3 == this.m_dbType) {
            return IPFTest.m_taskDscr[1];
        }
        if (8 == this.m_dbType) {
            return IPFTest.m_taskDscr[5];
        }
        return null;
    }

    public boolean isMandatory() {
        return false;
    }

    public ICnfgTaskPrompt[] getPrompts() {
        return null;
    }

    public boolean run(Object[] arg0, ICnfgFeedback arg1) throws Exception {
        if (StringUtils.isBlank((String)this.m_dbURL)) {
            throw new Exception("IPFDbConnTask: URL not set");
        }
        if (StringUtils.isBlank((String)this.m_dbUser) && this.nonUserAuth()) {
            throw new Exception(IPFTest.m_testErrMsgString[6] + this.m_dbURL);
        }
        if (this.m_dbType == 0) {
            throw new Exception("IPFDbConnTask: Database type not set");
        }
        try {
            this.getConnection();
        }
        catch (Exception e) {
            arg1.showError(IPFTest.m_testErrMsgString[6] + this.m_dbURL + ". The error encountered is \"" + e.getMessage() + "\"");
            if (e.getMessage().compareToIgnoreCase("no suitable driver") == 0) {
                throw new Exception(IPFTest.m_testErrMsgString[2] + this.m_dbURL);
            }
            return false;
        }
        if (null == this.m_dbConn) {
            arg1.showError(IPFTest.m_testErrMsgString[6] + this.m_dbURL);
            return false;
        }
        this.closeConnection();
        return true;
    }

    private boolean nonUserAuth() {
        return this.m_dbType != 7 && this.m_dbType != 9;
    }

    public void cancel(ICnfgFeedback arg0) throws Exception {
    }

    public int getStatus() {
        return 0;
    }

    public void setStatus(int arg0) {
    }

    protected Connection getConnection() throws SQLException {
        if (!this.m_driverLoaded) {
            this.setDriver(this.m_dbDriver);
        }
        Properties props = new Properties();
        if (this.advancedProperties != null && !this.advancedProperties.isEmpty()) {
            props.putAll((Map<?, ?>)this.advancedProperties);
        }
        LogLog.debug((String)("IPFDbConnTask: URL" + this.m_dbURL + " connection parameters  " + props));
        if (null == this.m_dbConn) {
            if (this.isOracleKerberos()) {
                props.put(LOGIN_ENTRY_NAME, this.loginEntryName);
                this.m_dbConn = DriverManager.getConnection(this.m_dbURL, props);
            } else if (this.isValidCredential()) {
                props.put(PROP_USER, this.m_dbUser);
                props.put(PROP_PASSWORD, this.m_dbPassword);
                this.m_dbConn = DriverManager.getConnection(this.m_dbURL, props);
            } else {
                this.m_dbConn = DriverManager.getConnection(this.m_dbURL);
            }
        }
        if (null == this.m_dbConn) {
            return this.m_dbConn;
        }
        return this.m_dbConn;
    }

    private boolean isValidCredential() {
        return StringUtils.isNotBlank((String)this.m_dbUser) && StringUtils.isNotBlank((String)this.m_dbPassword);
    }

    private boolean isOracleKerberos() {
        return this.m_dbType == 9;
    }

    private void setDriver(String driverClass) {
        try {
            Class.forName(driverClass);
            this.m_driverLoaded = true;
        }
        catch (ClassNotFoundException e) {
            LogLog.error((String)("IPFDbConnTask: Failed to load driver " + driverClass), (Throwable)e);
        }
        catch (Exception e) {
            LogLog.error((String)("IPFDbConnTask: Failed to load driver " + driverClass), (Throwable)e);
        }
    }

    protected void closeConnection() throws Exception {
        try {
            if (this.m_dbConn != null && !this.m_dbConn.isClosed()) {
                this.m_dbConn.close();
                this.m_dbConn = null;
            }
        }
        catch (SQLException e) {
            LogLog.error((String)"IPFDbConnTask: Error closing connection ", (Throwable)e);
            throw e;
        }
    }
}

