/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.IPFTest;

import com.cognos.IPFTest.IPFDbConnTask;
import com.cognos.IPFTest.IPFTestUtils;
import com.cognos.IPFTest.IPFVerifyDbTask;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import com.cognos.indications.LogIPFConfigure;
import com.ibm.cognos.conformance.CNFMConfiguration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.helpers.LogLog;
import org.dom4j.Element;

public class IPFTest
implements ICnfgTest {
    protected static boolean m_useCfgapiEncryption = true;
    protected static String[] m_testErrMsgString;
    private static Properties m_IPFDBConnProp;
    protected ArrayList<ICnfgTask> m_taskList = null;
    protected static String m_taskLabel;
    protected static String[] m_taskDscr;

    public boolean initialize(ICCLConfiguration cclConfig, ICnfgFeedback arg1) {
        LinkedList<Element> instanceElementList = new LinkedList<Element>();
        try {
            this.initializeResources(cclConfig, arg1);
            this.initializeIPFParams(cclConfig, instanceElementList, arg1);
        }
        catch (Exception e) {
            return false;
        }
        return this.parseIPFAppenders(instanceElementList, arg1);
    }

    public ICnfgTask[] getTasks(String arg0, ICnfgFeedback arg1) {
        if (this.m_taskList.isEmpty()) {
            arg1.showInformational(m_testErrMsgString[1]);
            return null;
        }
        if (null == arg0 || arg0.length() == 0 || arg0.endsWith("IPF") || -1 == arg0.indexOf("IPF")) {
            return this.addTasks(this.m_taskList);
        }
        StringTokenizer st = new StringTokenizer(arg0, "/");
        if (st.countTokens() >= 4) {
            for (int ii = 0; ii < 3; ++ii) {
                st.nextToken();
            }
        }
        String dbForTesting = st.nextToken();
        Iterator<ICnfgTask> it = this.m_taskList.iterator();
        ArrayList<ICnfgTask> tmpList = new ArrayList<ICnfgTask>();
        while (it.hasNext()) {
            ICnfgTask aTask = it.next();
            if (dbForTesting.compareTo(((IPFDbConnTask)aTask).getDBInstanceName()) != 0) continue;
            tmpList.add(aTask);
        }
        return this.addTasks(tmpList);
    }

    private ICnfgTask[] addTasks(ArrayList taskList) {
        int i = 0;
        int tasklistSize = taskList.size();
        boolean bVerifyCNFMDisabled = this.verifyCNFMIsDisabled();
        if (!bVerifyCNFMDisabled) {
            tasklistSize *= 2;
        }
        ICnfgTask[] IPFtasks = new ICnfgTask[tasklistSize];
        for (IPFDbConnTask testTask : taskList) {
            IPFtasks[i] = testTask;
            if (!bVerifyCNFMDisabled) {
                IPFVerifyDbTask verifyTask = new IPFVerifyDbTask(testTask);
                IPFtasks[i + 1] = verifyTask;
                i += 2;
                continue;
            }
            ++i;
        }
        return IPFtasks;
    }

    private boolean verifyCNFMIsDisabled() {
        try {
            CNFMConfiguration conf = CNFMConfiguration.getInstance();
            return conf.getCNFMCheckingDisabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void terminate(ICnfgFeedback arg0) {
        if (this.m_taskList.size() != 0) {
            this.m_taskList.clear();
        }
    }

    private void initializeIPFParams(ICCLConfiguration cclConfig, List instanceElementList, ICnfgFeedback arg1) throws CCLConfigurationException {
        Element configElement;
        try {
            configElement = cclConfig.getValueElement("IPF", m_useCfgapiEncryption);
        }
        catch (CCLConfigurationException e) {
            LogLog.error((String)("Failed to read IPF startup parameters from ICCLConfiguration; error " + e.getMessage()));
            arg1.showError(m_testErrMsgString[0]);
            throw e;
        }
        if (null == configElement) {
            LogLog.error((String)"ICCLConfiguration returned no IPF startup parameters");
            arg1.showError(m_testErrMsgString[0]);
            throw new CCLConfigurationException(9);
        }
        if (null != instanceElementList) {
            List instancesElementList = configElement.elements(IPFTestUtils.qnInstances);
            int length = instancesElementList.size();
            for (int loop = 0; loop < length; ++loop) {
                Element instancesElement = (Element)instancesElementList.get(loop);
                String nameAttr = instancesElement.attributeValue("name");
                if (null == nameAttr || !nameAttr.equals("appender")) continue;
                instanceElementList.addAll(instancesElement.elements(IPFTestUtils.qnInstance));
                break;
            }
        }
    }

    private boolean parseIPFAppenders(List<Element> instanceElementList, ICnfgFeedback arg1) {
        if (null == instanceElementList) {
            LogLog.warn((String)"Logging DB Connection Test: No appenders defined");
            arg1.showWarning(m_testErrMsgString[1]);
            return false;
        }
        this.m_taskList = new ArrayList();
        for (Element instanceElement : instanceElementList) {
            if (null == instanceElement) continue;
            String classAttr = instanceElement.attribute("class").getValue();
            String nameAttr = instanceElement.attribute("name").getValue();
            if (null == classAttr || null == nameAttr || !classAttr.equalsIgnoreCase("ipf_database")) continue;
            Element databaseInstancesElement = instanceElement.element(IPFTestUtils.qnInstances);
            Element databaseInstanceElement = databaseInstancesElement.element(IPFTestUtils.qnInstance);
            this.parseJDBCConnProps(databaseInstanceElement, this.m_taskList, arg1, nameAttr);
        }
        return true;
    }

    private boolean parseJDBCConnProps(Element dbInstanceElement, ArrayList<ICnfgTask> taskList, ICnfgFeedback arg1, String dbInstanceName) {
        String driverString;
        if (null == dbInstanceElement) {
            LogLog.warn((String)("Logging DB Connection Test: No appender named '" + dbInstanceName + "' defined"));
            arg1.showWarning(m_testErrMsgString[1]);
            return false;
        }
        IPFDbConnTask connTask = new IPFDbConnTask();
        connTask.setDBInstanceName(dbInstanceName);
        Map dbParameterMap = LogIPFConfigure.parseDBParameters((Element)dbInstanceElement);
        String serverHost = (String)dbParameterMap.get("server");
        String dbName = (String)dbParameterMap.get("name");
        String dbUser = (String)dbParameterMap.get("username");
        int dbType = Integer.parseInt((String)dbParameterMap.get("type"));
        connTask.setDBName(dbName);
        connTask.setDBUser(dbUser);
        connTask.setDBPassword((String)dbParameterMap.get("password"));
        connTask.setDBType(dbType);
        if (LogIPFConfigure.m_advancedProperties != null && !LogIPFConfigure.m_advancedProperties.isEmpty()) {
            connTask.setAdvancedProperties(LogIPFConfigure.m_advancedProperties);
        }
        if (this.isOracleKerberosAuth(dbType)) {
            connTask.setLoginEntryName(LogIPFConfigure.getLoginEntryName());
        }
        if (null == (driverString = (String)dbParameterMap.get("driver"))) {
            LogLog.warn((String)("IPFTest: DB driver for '" + dbType + "' is invalid. Unable to connect to audit db '" + serverHost + " " + dbName + "'."));
            arg1.showWarning(m_testErrMsgString[2] + dbType);
            return false;
        }
        connTask.setDBDriver(driverString);
        LogLog.debug((String)("LogIPFTest: Setting DB Driver to: " + driverString));
        String dbConnectionString = (String)dbParameterMap.get("connection_string");
        if (null == dbConnectionString) {
            LogLog.warn((String)("IPFTest: DB connection string is invalid. Unable to connect to audit db '" + serverHost + " " + dbName + "'. Return false."));
            arg1.showWarning(m_testErrMsgString[3] + dbType);
            return false;
        }
        LogLog.debug((String)("IPFTest::parseJDBCConnProps() - Setting DB Connection to: " + dbConnectionString));
        connTask.setDBType(dbType);
        connTask.setDBURL(dbConnectionString);
        taskList.add(connTask);
        return true;
    }

    private boolean isOracleKerberosAuth(int dbType) {
        return dbType == 9;
    }

    private void initializeResources(ICCLConfiguration cclConfig, ICnfgFeedback arg1) throws Exception {
        m_testErrMsgString = new String[8];
        m_taskDscr = new String[7];
        try {
            ResourceBundle textvals = ResourceBundle.getBundle("logtest", Locale.getDefault());
            IPFTest.m_testErrMsgString[0] = textvals.getString("IPFTEST_00");
            IPFTest.m_testErrMsgString[1] = textvals.getString("IPFTEST_01");
            IPFTest.m_testErrMsgString[2] = textvals.getString("IPFTEST_02");
            IPFTest.m_testErrMsgString[3] = textvals.getString("IPFTEST_03");
            IPFTest.m_testErrMsgString[4] = textvals.getString("IPFTEST_04");
            IPFTest.m_testErrMsgString[5] = textvals.getString("IPFTEST_05");
            IPFTest.m_testErrMsgString[6] = textvals.getString("IPFTEST_06");
            IPFTest.m_testErrMsgString[7] = textvals.getString("IPFTEST_07");
            m_taskLabel = textvals.getString("IPFTEST_Label");
            IPFTest.m_taskDscr[0] = textvals.getString("IPFTEST_Descr_MSSQL");
            IPFTest.m_taskDscr[1] = textvals.getString("IPFTEST_Descr_DB2");
            IPFTest.m_taskDscr[2] = textvals.getString("IPFTEST_Descr_ORA");
            IPFTest.m_taskDscr[3] = textvals.getString("IPFTEST_Descr_SYB");
            IPFTest.m_taskDscr[4] = textvals.getString("IPFTEST_Descr_DERBY");
            IPFTest.m_taskDscr[5] = textvals.getString("IPFTEST_Descr_INFORMIX");
            IPFTest.m_taskDscr[6] = textvals.getString("IPFTEST_Verify_Descr");
        }
        catch (Exception e) {
            arg1.showError(e.getMessage());
            throw e;
        }
    }

    public String getErrMsg(int errCode) {
        if (errCode < 0 || errCode > 6) {
            return null;
        }
        return m_testErrMsgString[errCode];
    }

    static {
        m_IPFDBConnProp = null;
        if (null == m_IPFDBConnProp) {
            m_IPFDBConnProp = new Properties();
        }
        try {
            ResourceBundle resBund = ResourceBundle.getBundle("com.cognos.indications.IPFInternal", new Locale("ov", "CA"));
            Enumeration<String> parmNames = resBund.getKeys();
            while (parmNames.hasMoreElements()) {
                String parmName = parmNames.nextElement();
                String parmValue = resBund.getString(parmName);
                if (parmName == null || parmName.length() < 1) continue;
                m_IPFDBConnProp.remove(parmName);
                if (parmValue == null) {
                    m_IPFDBConnProp.setProperty(parmName, "");
                    continue;
                }
                m_IPFDBConnProp.setProperty(parmName, parmValue);
            }
        }
        catch (Exception e) {
            LogLog.warn((String)"LogIPFConfigure - Unknown error during initialization");
        }
    }
}

