/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.IPFTest;

import com.cognos.IPFTest.IPFDbConnTask;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFLog;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class IPFTestUtils {
    protected static final String IPF_TAG = "IPF";
    protected static final String CRN_INSTANCE_TAG = "instance";
    protected static final String CRN_INSTANCES_TAG = "instances";
    protected static final String CRN_PARAMETER_TAG = "parameter";
    protected static final String CRN_VALUE_TAG = "value";
    protected static final Namespace nsCRN = new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
    protected static final QName qnInstances = new QName("instances", nsCRN);
    protected static final QName qnInstance = new QName("instance", nsCRN);
    protected static final QName qnParameter = new QName("parameter", nsCRN);
    protected static final QName qnValue = new QName("value", nsCRN);
    protected static final String NAME_ATTR = "name";
    protected static final String CLASS_ATTR = "class";
    protected static final String APPENDER_VALUE = "appender";
    protected static final String CRN_DBMS_APPENDER_CLASS = "ipf_database";

    protected static IPFDbConnTask getDbConnTask(Element dbInstanceElement) throws Exception {
        String driverString;
        if (dbInstanceElement == null) {
            LogIPFLog.debug((String)"IPFTestUtils::getDbConnTask() - No instance element, return null.");
            return null;
        }
        IPFDbConnTask connTask = new IPFDbConnTask();
        Map dbParameterMap = LogIPFConfigure.parseDBParameters((Element)dbInstanceElement);
        String serverHost = (String)dbParameterMap.get("server");
        String dbName = (String)dbParameterMap.get(NAME_ATTR);
        String dbUser = (String)dbParameterMap.get("username");
        int dbType = Integer.parseInt((String)dbParameterMap.get("type"));
        connTask.setDBName(dbName);
        connTask.setDBUser(dbUser);
        connTask.setDBPassword((String)dbParameterMap.get("password"));
        connTask.setDBType(dbType);
        if (dbType == 0) {
            String msg = "IPFTestUtils::getDbConnTask() - Database type not set.";
            LogIPFLog.debug((String)msg);
            throw new Exception(msg);
        }
        if ((dbUser == null || dbUser.length() == 0) && dbType != 7 && dbType != 9) {
            String msg = "IPFTestUtils::getDbConnTask() - User not set.";
            LogIPFLog.debug((String)msg);
            throw new Exception(msg);
        }
        if (dbType == 9) {
            connTask.setLoginEntryName(LogIPFConfigure.getLoginEntryName());
            connTask.setAdvancedProperties(LogIPFConfigure.getAdvancedProperties());
        }
        if (null == (driverString = (String)dbParameterMap.get("driver"))) {
            String msg = "IPFTestUtils::getDbConnTask() - DB driver is invalid. Unable to connect to audit db '" + serverHost + " " + dbName + "'.";
            LogIPFLog.debug((String)msg);
            throw new Exception(msg);
        }
        connTask.setDBDriver(driverString);
        String dbConnectionString = (String)dbParameterMap.get("connection_string");
        if (null == dbConnectionString) {
            String msg = "IPFTestUtils::getDbConnTask() - DB connection string is invalid. Unable to connect to audit db '" + serverHost + " " + dbName + "'. Return false.";
            LogIPFLog.debug((String)msg);
            throw new Exception(msg);
        }
        LogIPFLog.debug((String)("IPFTestUtils::getDbConnTask() - Setting DB Connection to: " + dbConnectionString));
        connTask.setDBURL(dbConnectionString);
        return connTask;
    }
}

