/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.IPFTest;

import com.cognos.IPFTest.IPFDbConnTask;
import com.cognos.IPFTest.IPFTestUtils;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogIPFConfigure;
import com.cognos.indications.LogIPFLog;
import com.cognos.indications.dbstore.LogDbStoreFactory;
import java.sql.Connection;
import java.util.LinkedList;
import org.dom4j.Element;

public class IPFUpgrade {
    public static boolean auditDatabasesRequireUpgrade(ICCLConfiguration cclConfig) throws Exception {
        LinkedList instanceElementList = new LinkedList();
        try {
            LogIPFConfigure.parseIPFStartupParams((ICCLConfiguration)cclConfig, instanceElementList);
        }
        catch (Exception e) {
            throw new Exception("IPFUpgrade::auditDatabasesRequireUpgrade() - Failed to parse IPF startup params. " + e.getMessage());
        }
        try {
            return IPFUpgrade.checkDBsForUpgrade(instanceElementList);
        }
        catch (Exception e) {
            throw new Exception("IPFUpgrade::auditDatabasesRequireUpgrade() - Failed to check db for upgrade. " + e.getMessage());
        }
    }

    private static boolean checkDBsForUpgrade(LinkedList instanceElementList) throws Exception {
        if (null == instanceElementList) {
            LogIPFLog.warn((String)"IPFUpgrade::checkDBsForUpgrade() - No db appenders defined, so no upgrade is required.");
            return false;
        }
        int length = instanceElementList.size();
        for (int loop = 0; loop < length; ++loop) {
            Element databaseInstanceElement;
            boolean result;
            Element databaseInstancesElement;
            Element instanceElement = (Element)instanceElementList.get(loop);
            if (null == instanceElement) continue;
            String classAttr = instanceElement.attribute("class").getValue();
            String nameAttr = instanceElement.attribute("name").getValue();
            if (null == classAttr || null == nameAttr || !classAttr.equalsIgnoreCase("ipf_database") || (databaseInstancesElement = instanceElement.element(IPFTestUtils.qnInstances)) == null || !(result = IPFUpgrade.checkDBUpgrade(databaseInstanceElement = databaseInstancesElement.element(IPFTestUtils.qnInstance)))) continue;
            return true;
        }
        LogIPFLog.debug((String)"IPFUpgrade::checkDBsForUpgrade() - No upgrade is required.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkDBUpgrade(Element dbInstanceElement) throws Exception {
        boolean result;
        block12: {
            LogIPFLog.debug((String)"IPFUpgrade::checkDBUpgrade() - begin.");
            result = false;
            IPFDbConnTask connTask = null;
            try {
                connTask = IPFTestUtils.getDbConnTask(dbInstanceElement);
            }
            catch (Exception e) {
                LogIPFLog.debug((String)"IPFUpgrade::checkDBUpgrade() - Unable to get DB conn task.", (Throwable)e);
                throw e;
            }
            if (connTask == null) {
                return false;
            }
            Connection conn = null;
            try {
                try {
                    conn = connTask.getConnection();
                }
                catch (Exception e) {
                    LogIPFLog.error((String)("IPFUpgrade::checkDBUpgrade() - Failed to connect to " + connTask.getDBURL()), (Throwable)e);
                    throw e;
                }
                if (conn == null) {
                    String msg = "IPFUpgrade::checkDBUpgrade() - The connection to " + connTask.getDBURL() + " is null.";
                    LogIPFLog.error((String)msg);
                    throw new Exception(msg);
                }
                LogDbStoreFactory dbFactory = new LogDbStoreFactory();
                if (dbFactory.isDatabaseEmpty(conn)) {
                    result = false;
                    break block12;
                }
                try {
                    result = dbFactory.databaseRequiresUpgrade();
                }
                catch (Exception e) {
                    LogIPFLog.error((String)"IPFUpgrade::checkDBUpgrade() - Exception when call databaseRequiresUpgrade() - ", (Throwable)e);
                    throw e;
                }
            }
            finally {
                connTask.closeConnection();
            }
        }
        LogIPFLog.debug((String)("IPFUpgrade::checkDBUpgrade() - succeed, return " + result));
        return result;
    }
}

