/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.IPFTest;

import com.cognos.IPFTest.IPFDbConnTask;
import com.cognos.IPFTest.IPFTest;
import com.cognos.crconfig.ICnfgFeedback;
import com.ibm.cognos.conformance.CNFMCheckResult;
import com.ibm.cognos.conformance.CNFMDBVersionInfo;
import com.ibm.cognos.conformance.CNFMJDBCDatabaseChecking;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.log4j.helpers.LogLog;

public class IPFVerifyDbTask
extends IPFDbConnTask {
    DatabaseMetaData m_dbMetadata = null;

    IPFVerifyDbTask(IPFDbConnTask connTask) {
        this.m_dbName = connTask.m_dbName;
        this.m_dbDriver = connTask.m_dbDriver;
        this.m_dbUser = connTask.m_dbUser;
        this.m_dbPassword = connTask.m_dbPassword;
        this.m_dbType = connTask.m_dbType;
        this.m_dbURL = connTask.m_dbURL;
        this.m_dbInstanceName = connTask.m_dbInstanceName;
    }

    private CNFMDBVersionInfo getDBVersion() {
        CNFMDBVersionInfo dbVerInfo = new CNFMDBVersionInfo();
        try {
            Connection conn;
            if (this.m_dbMetadata == null && (conn = this.getConnection()) != null) {
                this.m_dbMetadata = conn.getMetaData();
            }
            if (this.m_dbMetadata != null) {
                dbVerInfo.setDBMajorVersion(this.m_dbMetadata.getDatabaseMajorVersion());
                dbVerInfo.setDBMinorVersion(this.m_dbMetadata.getDatabaseMinorVersion());
                dbVerInfo.setProductName(this.m_dbMetadata.getDatabaseProductName());
                dbVerInfo.setProductVersion(this.m_dbMetadata.getDatabaseProductVersion());
                dbVerInfo.setDriverName(this.m_dbMetadata.getDriverName());
                dbVerInfo.setDriverVersion(this.m_dbMetadata.getDriverVersion());
                dbVerInfo.setDriverMajorVersion(this.m_dbMetadata.getDriverMajorVersion());
                dbVerInfo.setDriverMinorVersion(this.m_dbMetadata.getDriverMinorVersion());
                return dbVerInfo;
            }
        }
        catch (SQLException se) {
            LogLog.error((String)("Exception when get connection and metadata in getDBVersion() with db instance '" + this.getDBInstanceName() + "': "), (Throwable)se);
            return null;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return IPFTest.m_taskDscr[6];
    }

    @Override
    public String getLabel() {
        return IPFTest.m_taskLabel;
    }

    @Override
    public boolean run(Object[] arg0, ICnfgFeedback arg1) throws Exception {
        try {
            boolean result = false;
            CNFMDBVersionInfo dbVer = this.getDBVersion();
            if (dbVer != null) {
                CNFMJDBCDatabaseChecking dbchecking = new CNFMJDBCDatabaseChecking();
                dbchecking.setVersionInfo(dbVer.convertToItemInfo());
                CNFMCheckResult checkResult = dbchecking.validate();
                if (checkResult != null) {
                    result = checkResult.isCheckingOk();
                    if (result) {
                        arg1.showInformational(checkResult.buildOutput());
                    } else {
                        arg1.showWarning(checkResult.buildOutput());
                    }
                } else {
                    arg1.showWarning(IPFTest.m_testErrMsgString[7] + this.m_dbURL);
                    result = false;
                }
            } else {
                arg1.showError(IPFTest.m_testErrMsgString[7] + this.m_dbURL);
                result = false;
            }
            this.closeConnection();
            return result;
        }
        catch (Exception e) {
            arg1.showError(IPFTest.m_testErrMsgString[7] + this.m_dbURL);
            return false;
        }
    }
}

