<?xml version="1.0" encoding="UTF-8"?>
<!--
 Licensed Materials - Property of IBM

 IBM Cognos Products: FMMD_ModelUpdate

 (C) Copyright IBM Corp. 2019, 2020

 US Government Users Restricted Rights - Use, duplication or disclosure 
 restricted by GSA ADP Schedule Contract with IBM Corp.
-->

<xsl:stylesheet version="2.0" xmlns:fm="http://www.developer.cognos.com/schemas/bmt/60/7" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output omit-xml-declaration="no" indent="no"/>
	<xsl:strip-space elements="*"/>

	<xsl:variable name="LOWER_CASE" select="'abcdefghijklmnopqrstuvwxyzàáâãäåæçèéêëìíîïðñòóôõöøùúûüýþšÿž'"/>
	<xsl:variable name="UPPER_CASE" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞŠŸŽ'"/>

	<!--
	    ***********************************************************************
		This xslt file is used to change case of a model.xml file
		User can specify from upper-case to lower-case, or vice vesa.
		User can specify one or more specific data soures are used in the search.
		User can specify whether dbQuery, or storedProdecure, or both are used in the search.
	-->

	<!--
		SHIFT CASE	
		Modify the followings to customize your case shift
		By default, upper-case is changed to lower-case.
	-->
	<xsl:variable name="FROM_CASE" select="$UPPER_CASE"/>
	<xsl:variable name="TO_CASE"   select="$LOWER_CASE"/>

	<!--
		LIST OF DATA SOURCE NAMES
		Modify the followings to match the user's data source names
		Otherwise data sources are ignored in search
	-->	
	<xsl:param  name="LIST_DS" select="'[LIST OF DATASOURCE NAME]'"/>

	<!--
		IGNORE DATA SOURCE NAMES
	-->
	<xsl:param  name="IGNORE_DS" select="true()"/>

	<!--
		QUERY OBJECTS: dbQuery or storedProcedure, or both
		
		By default both dbQuery, and storedProcedure objects are affected
		Change xpath on the line 136 of this file to something else to exclude it. eg.
		
		<xsl:variable name="dbQuery"       select="fm:definition/fm:dbQuery/fm:sqlxxx"/>
		<xsl:variable name="storedProc"    select="fm:definition/fm:storedProcedure/fm:dataSourceRefxxx"/>	
	-->
	
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<!-- case shift for canonicalName of storedProcedure -->
	<xsl:template match="//fm:querySubject/fm:definition/fm:storedProcedure/fm:canonicalName">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:value-of select="translate(., $FROM_CASE, $TO_CASE)"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="//fm:querySubject/fm:definition/fm:storedProcedure/*[not(name()='canonicalName')]">
		<xsl:copy-of select="."/>
	</xsl:template>
	
	<xsl:template match="//fm:querySubject/fm:definition/fm:storedProcedure">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:for-each select=".">
				<xsl:apply-templates/>
			</xsl:for-each>
		</xsl:copy>
	</xsl:template>
	
	<!-- case shift for sql of dbQuery -->
	<xsl:template match="//fm:querySubject/fm:definition/fm:dbQuery/fm:sql">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:value-of select="concat(substring-before(.,']'), ']', translate(substring-after(.,']'), $FROM_CASE, $TO_CASE))"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="//fm:querySubject/fm:definition/fm:dbQuery/*[not(name()='sql')]">
		<xsl:copy-of select="."/>
	</xsl:template>
	
	<xsl:template match="//fm:querySubject/fm:definition/fm:dbQuery">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:for-each select=".">
				<xsl:apply-templates/>
			</xsl:for-each>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="//fm:querySubject/fm:definition/*[not(name()='dbQuery' or name()='storedProcedure')]">
		<xsl:copy-of select="."/>
	</xsl:template>
	
	<xsl:template match="//fm:querySubject/fm:definition">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:for-each select=".">
				<xsl:apply-templates/>
			</xsl:for-each>
		</xsl:copy>
	</xsl:template>
	
	<!-- case shift for externalName of queryItems -->
	<xsl:template match="//fm:querySubject/fm:queryItem/fm:externalName">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:value-of select="translate(., $FROM_CASE, $TO_CASE)"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="//fm:querySubject/fm:queryItem/*[not(name()='externalName')]">
		<xsl:copy-of select="."/>
	</xsl:template>
	
	<xsl:template match="//fm:querySubject/fm:queryItem">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:for-each select=".">
				<xsl:apply-templates/>
			</xsl:for-each>
		</xsl:copy>
	</xsl:template>

	<!-- deep copy of all children except queryItem and definition-->
	<xsl:template match="//fm:querySubject/*[not(name()='queryItem' or name()='definition')]">
		<xsl:copy-of select="."/>
	</xsl:template>
	
	<!-- DBQUERY or STORED PROCEDURE -->
	<xsl:template match="//fm:querySubject">
		<xsl:variable name="dbQuery_cognos" select="fm:definition/fm:dbQuery/fm:sql[@type='cognos']"/>
		<xsl:variable name="storedProc" select="fm:definition/fm:storedProcedure/fm:dataSourceRef"/>		
		<xsl:variable name="dbQuery_trivial">
			<xsl:choose>
				<xsl:when test="starts-with($dbQuery_cognos, 'Select *from[')">
					<xsl:value-of select="$dbQuery_cognos"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="''"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="dbQuery_ds" select="concat('[', substring-after(substring-before($dbQuery_trivial, ']'), '['), ']')"/>					
		<xsl:variable name="storedProc_ds" select="concat('[', substring-before(substring-after($storedProc, '[].[dataSources].['), ']'), ']')"/>		

		<xsl:variable name="match_with_ds" select="contains($LIST_DS, $dbQuery_ds) or contains($LIST_DS, $storedProc_ds)"/>
		<xsl:variable name="match_without_ds" select="$IGNORE_DS and (not(contains($dbQuery_ds, '[]')) or not(contains($storedProc_ds, '[]')))"/>
		
		<xsl:variable name="db_sp_match" select="$match_with_ds or $match_without_ds"/>
		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="$db_sp_match">
					<xsl:copy>
						<xsl:apply-templates select="@*"/>
						<xsl:apply-templates/>
					</xsl:copy>		
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="."/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	

	<xsl:template match="//fm:function/fm:canonicalName">
		<xsl:copy>
			<xsl:apply-templates select="@*"/>
			<xsl:value-of select="translate(., $FROM_CASE, $TO_CASE)"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="//fm:function/*[not(name()='canonicalName')]">
		<xsl:copy-of select="."/>
	</xsl:template>
	
	<!-- FUNCTIONS -->
	<xsl:template match="//fm:function">
		<xsl:variable name="function" select="fm:dataSourceRef"/>		
		<xsl:variable name="function_ds" select="concat('[', substring-before(substring-after($function, '[].[dataSources].['), ']'), ']')"/>		

		<xsl:variable name="fn_match" select="contains($LIST_DS, $function_ds) or ($IGNORE_DS and not(contains($function_ds,'[]')))"/>
		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="$fn_match">
					<xsl:copy>
						<xsl:apply-templates select="@*"/>
						<xsl:apply-templates/>
					</xsl:copy>		
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="."/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
