/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.AdditiveExpressionSort;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Clause;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import java.util.Vector;

public class AdditiveExpressionSortList
extends Clause {
    Vector<IExpressionFragment> subClauses = new Vector();

    @Override
    public int getNbSubExpressions() {
        return this.subClauses.size();
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        return this.subClauses.get(fragmentNb);
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        this.subClauses.set(fragmentNb, fragment);
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    Clause optimize(BooleanValue changed) throws ParseTreeException {
        if (this.subClauses != null) {
            int i = 0;
            while (i < this.subClauses.size()) {
                Clause ex = (Clause)this.subClauses.get(i);
                if ((ex = ex.optimize(changed)) == null) {
                    this.subClauses.removeElementAt(i);
                    continue;
                }
                this.subClauses.set(i, ex);
                ++i;
            }
        }
        return this;
    }

    @Override
    protected boolean needWrapping(IExpressionFragment fragment, ExpressionFragment.AppendContext context) {
        return false;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        int nb = this.subClauses.size();
        for (int i = 0; i < nb; ++i) {
            if (i != 0) {
                this.appendListSeparator(buffer, context);
            }
            AdditiveExpressionSort expr = (AdditiveExpressionSort)this.subClauses.get(i);
            this.appendHelper(buffer, expr, context);
        }
    }

    public void add(AdditiveExpressionSort expr) {
        this.subClauses.add(expr);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AdditiveExpressionSortList)) {
            return false;
        }
        AdditiveExpressionSortList o = (AdditiveExpressionSortList)other;
        return this.subClauses.equals(o.subClauses);
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.subClauses != null) {
            int nbExpressions = this.subClauses.size();
            for (int i = 0; i < nbExpressions; ++i) {
                IExpression expr = (IExpression)this.subClauses.get(i);
                result = result >> 1 ^ expr.hashCode();
            }
        }
        return result;
    }
}

