/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionType;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionTypeValidator;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ILeftSetable;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvalidTypeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;

public class BetweenExpression
extends Expression
implements ILeftSetable {
    IExpression lhs;
    IExpression min;
    IExpression max;

    public BetweenExpression() {
    }

    public BetweenExpression(IExpression lhs, IExpression minExpr, IExpression maxExpr) {
        this.lhs = lhs;
        this.min = minExpr;
        this.max = maxExpr;
    }

    @Override
    public void setLhs(IExpression expr) throws ParseTreeException {
        if (expr == null) {
            throw new ParseTreeException("Expression may not be null");
        }
        this.lhs = expr;
    }

    public void setMin(IExpression expr) throws ParseTreeException {
        if (expr == null) {
            throw new ParseTreeException("Expression may not be null");
        }
        this.min = expr;
    }

    public void setMax(IExpression expr) throws ParseTreeException {
        if (expr == null) {
            throw new ParseTreeException("Expression may not be null");
        }
        this.max = expr;
    }

    @Override
    public int getNbSubExpressions() {
        return 3;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb == 0) {
            return this.lhs;
        }
        if (fragmentNb == 1) {
            return this.min;
        }
        if (fragmentNb == 2) {
            return this.max;
        }
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb == 0) {
            this.lhs = (IExpression)fragment;
        } else if (fragmentNb == 1) {
            this.min = (IExpression)fragment;
        } else if (fragmentNb == 2) {
            this.max = (IExpression)fragment;
        } else {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        this.lhs = this.lhs.optimize(changed);
        this.min = this.min.optimize(changed);
        this.max = this.max.optimize(changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        this.appendHelper(buffer, this.lhs, context);
        buffer.append(" BETWEEN ");
        this.appendHelper(buffer, this.min, context);
        buffer.append(" AND ");
        this.appendHelper(buffer, this.max, context);
    }

    @Override
    public ExpressionType getType() throws InvalidTypeException {
        ExpressionType lhsType = this.lhs.getType();
        ExpressionType minType = this.min.getType();
        ExpressionType maxType = this.max.getType();
        if (!ExpressionTypeValidator.isConsistent(lhsType, minType)) {
            return ExpressionType.ERROR;
        }
        if (!ExpressionTypeValidator.isConsistent(lhsType, maxType)) {
            return ExpressionType.ERROR;
        }
        if (!ExpressionTypeValidator.isConsistent(minType, maxType)) {
            return ExpressionType.ERROR;
        }
        return ExpressionType.BOOLEAN;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof BetweenExpression)) {
            return false;
        }
        BetweenExpression o = (BetweenExpression)other;
        if (!this.lhs.equals(o.lhs)) {
            return false;
        }
        if (!this.min.equals(o.min)) {
            return false;
        }
        return this.max.equals(o.max);
    }

    @Override
    public int hashCode() {
        int b;
        int result = this.getClass().hashCode();
        if (this.lhs != null) {
            b = this.lhs.hashCode();
            result ^= b;
        }
        if (this.min != null) {
            b = this.min.hashCode();
            result ^= b;
        }
        if (this.max != null) {
            b = this.max.hashCode();
            result ^= b;
        }
        return result;
    }
}

