/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ILeftSetable;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;

public abstract class BinaryExpression
extends Expression
implements ILeftSetable {
    private IExpression m_lhs;
    private String m_operator;
    private IExpression m_rhs;

    public BinaryExpression(IExpression lhs, String operator, IExpression rhs) {
        this.m_lhs = lhs;
        this.m_operator = operator;
        this.m_rhs = rhs;
    }

    BinaryExpression(String operator) {
        this.m_operator = operator;
    }

    @Override
    public final void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        this.appendHelper(buffer, this.getLhs(), context);
        buffer.append(' ');
        buffer.append(this.m_operator);
        buffer.append(' ');
        this.appendHelper(buffer, this.getRhs(), context);
    }

    @Override
    public final void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    protected void optimizeHelper(BooleanValue changed) throws ParseTreeException {
        this.m_lhs = this.m_lhs.optimize(changed);
        this.m_rhs = this.m_rhs.optimize(changed);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof BinaryExpression)) {
            return false;
        }
        BinaryExpression otherExpr = (BinaryExpression)other;
        if (!this.m_lhs.equals(otherExpr.m_lhs)) {
            return false;
        }
        if (!this.m_rhs.equals(otherExpr.m_rhs)) {
            return false;
        }
        return this.getClass().equals(otherExpr.getClass());
    }

    public IExpression getLhs() {
        return this.m_lhs;
    }

    public IExpression getRhs() {
        return this.m_rhs;
    }

    public void setRhs(IExpression rhs) throws ParseTreeException {
        if (rhs == null) {
            throw new ParseTreeException("rhs may not be null");
        }
        this.m_rhs = rhs;
    }

    @Override
    public void setLhs(IExpression lhs) throws ParseTreeException {
        if (lhs == null) {
            throw new ParseTreeException("lhs may not be null");
        }
        this.m_lhs = lhs;
    }

    @Override
    public int getNbSubExpressions() {
        return 2;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            return this.m_lhs;
        }
        return this.m_rhs;
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            this.m_lhs = (IExpression)fragment;
        } else {
            this.m_rhs = (IExpression)fragment;
        }
    }

    @Override
    public int hashCode() {
        int b;
        int result = this.getClass().hashCode();
        if (this.m_lhs != null) {
            b = this.m_lhs.hashCode();
            result ^= b;
        }
        if (this.m_rhs != null) {
            b = this.m_rhs.hashCode();
            result ^= b;
        }
        return result;
    }

    public String getOperator() {
        return this.m_operator;
    }
}

