/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ISimpleExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Type;

public class CastFunctionExpression
extends Expression
implements ISimpleExpression {
    private IExpression expr;
    private Type target;

    public CastFunctionExpression(IExpression expr, Type target) {
        this.expr = expr;
        this.target = target;
    }

    @Override
    public int getNbSubExpressions() {
        return 1;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        return this.expr;
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        this.expr = (IExpression)fragment;
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        this.expr = this.expr.optimize(changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append("CAST(");
        this.appendHelper(buffer, this.expr, context);
        super.appendListSeparator(buffer, context);
        this.target.appendTo(buffer, context);
        buffer.append(")");
    }

    @Override
    protected boolean needWrapping(IExpressionFragment fragment, ExpressionFragment.AppendContext context) {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CastFunctionExpression)) {
            return false;
        }
        CastFunctionExpression other = (CastFunctionExpression)obj;
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public IExpressionFragment getExpr() {
        return this.expr;
    }

    public Type getTarget() {
        return this.target;
    }
}

