/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.FalseExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InLineComparisonExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IntegerLiteralExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.TrueExpression;

public class EqualityExpression
extends InLineComparisonExpression {
    public EqualityExpression(IExpression lhs, IExpression rhs) {
        super(lhs, "=", rhs);
    }

    public EqualityExpression() {
        super("=");
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        this.optimizeHelper(changed);
        IExpression lhs = this.getLhs();
        IExpression rhs = this.getRhs();
        if (lhs.equals(rhs)) {
            changed.set(true);
            return TrueExpression.getInstance();
        }
        if (lhs instanceof IntegerLiteralExpression && rhs instanceof IntegerLiteralExpression) {
            changed.set(true);
            return FalseExpression.getInstance();
        }
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof EqualityExpression)) {
            return false;
        }
        EqualityExpression otherExpr = (EqualityExpression)other;
        IExpression myLhs = this.getLhs();
        IExpression myRhs = this.getRhs();
        IExpression otherLhs = otherExpr.getLhs();
        IExpression otherRhs = otherExpr.getRhs();
        if (myLhs.equals(otherLhs) && myRhs.equals(otherRhs)) {
            return true;
        }
        return myLhs.equals(otherRhs) && myRhs.equals(otherLhs);
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        return result ^= super.hashCode();
    }
}

