/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.AllExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.AnyExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Clause;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionLocale;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ISimpleExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.SetExpression;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

abstract class ExpressionFragment
implements IExpressionFragment {
    ExpressionFragment() {
    }

    public String toString() {
        Locale locale = Locale.ENGLISH;
        return this.toString(locale);
    }

    public String toString(Locale locale) {
        StringBuffer buffer = new StringBuffer();
        this.appendTo(buffer, locale);
        return buffer.toString();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public final void appendTo(StringBuffer buffer, Locale locale) {
        AppendContext context = new AppendContext(locale);
        context.pushAncestor(this, true);
        this.appendTo(buffer, context);
    }

    public abstract void appendTo(StringBuffer var1, AppendContext var2);

    protected final void appendHelper(StringBuffer buffer, IExpressionFragment fragment, AppendContext context) {
        boolean wrap = this.needWrapping(fragment, context);
        context.pushAncestor(fragment, wrap);
        if (wrap) {
            buffer.append("(");
        }
        ((ExpressionFragment)fragment).appendTo(buffer, context);
        if (wrap) {
            buffer.append(")");
        }
        context.popAncestor();
    }

    protected boolean needWrapping(IExpressionFragment fragment, AppendContext context) {
        if (context.getDepth() == 0) {
            return false;
        }
        if (fragment instanceof Clause) {
            return false;
        }
        if (fragment instanceof ISimpleExpression) {
            return false;
        }
        if (fragment instanceof SetExpression) {
            return false;
        }
        return !(fragment instanceof AnyExpression) && !(fragment instanceof AllExpression);
    }

    protected static void optimizeExpressionSubtree(Vector<IExpression> expressions, BooleanValue changed) throws ParseTreeException {
        if (expressions != null) {
            int i = 0;
            while (i < expressions.size()) {
                IExpression ex = expressions.get(i);
                if ((ex = ex.optimize(changed)) == null) {
                    expressions.removeElementAt(i);
                    continue;
                }
                expressions.set(i, ex);
                ++i;
            }
        }
    }

    protected final void appendListSeparator(StringBuffer buffer, AppendContext context) {
        Locale locale = context.getLocale();
        String listSeparator = ExpressionLocale.getListSeparator(locale);
        buffer.append(listSeparator);
        buffer.append(' ');
    }

    protected static boolean equalsHelper(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    protected static class AppendContext {
        private Locale locale;
        private Stack<Ancestor> ancestors = new Stack();

        public AppendContext(Locale expressionLocale) {
            this.locale = expressionLocale;
        }

        public void pushAncestor(IExpressionFragment fragment, boolean wrapped) {
            Ancestor ancestor = new Ancestor(fragment, wrapped);
            this.ancestors.push(ancestor);
        }

        public void popAncestor() {
            this.ancestors.pop();
        }

        public int getDepth() {
            return this.ancestors.size();
        }

        public Locale getLocale() {
            return this.locale;
        }

        class Ancestor {
            IExpressionFragment ancestor;
            boolean wrapped;

            Ancestor(IExpressionFragment fragment, boolean wrapped) {
                this.ancestor = fragment;
                this.wrapped = wrapped;
            }
        }
    }
}

