/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Clause;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import java.util.Enumeration;
import java.util.Vector;

public class ExpressionList
extends Clause {
    Vector<IExpression> subExpressions = new Vector();

    public Enumeration<IExpression> getListContents() {
        return this.subExpressions.elements();
    }

    @Override
    public int getNbSubExpressions() {
        return this.subExpressions.size();
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        return this.subExpressions.get(fragmentNb);
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        this.subExpressions.set(fragmentNb, (IExpression)fragment);
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    Clause optimize(BooleanValue changed) throws ParseTreeException {
        ExpressionList.optimizeExpressionSubtree(this.subExpressions, changed);
        return this;
    }

    @Override
    protected boolean needWrapping(IExpressionFragment fragment, ExpressionFragment.AppendContext context) {
        return false;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        int nb = this.subExpressions.size();
        for (int i = 0; i < nb; ++i) {
            if (i != 0) {
                this.appendListSeparator(buffer, context);
            }
            IExpression expr = this.subExpressions.get(i);
            this.appendHelper(buffer, expr, context);
        }
    }

    public void add(IExpression expr) {
        this.subExpressions.add(expr);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ExpressionList)) {
            return false;
        }
        ExpressionList o = (ExpressionList)other;
        return this.subExpressions.equals(o.subExpressions);
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.subExpressions != null) {
            int nbExpressions = this.subExpressions.size();
            for (int i = 0; i < nbExpressions; ++i) {
                IExpression expr = this.subExpressions.get(i);
                result = result >> 1 ^ expr.hashCode();
            }
        }
        return result;
    }
}

