/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionType;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvalidTypeException;
import java.util.Iterator;
import java.util.Set;

public class ExpressionTypeValidator {
    static boolean isConsistent(ExpressionType a, ExpressionType b) {
        if (a == b) {
            return true;
        }
        if (a == ExpressionType.UNKNOWN) {
            return true;
        }
        if (b == ExpressionType.UNKNOWN) {
            return true;
        }
        if (a == ExpressionType.NULL) {
            return true;
        }
        return b == ExpressionType.NULL;
    }

    static boolean isConsistent(Integer a, Integer b) {
        return ExpressionTypeValidator.isConsistent((int)a, (int)b);
    }

    static boolean isConsistent(Set<Integer> a, Set<Integer> b) {
        boolean compatible = false;
        Iterator<Integer> aIter = a.iterator();
        while (aIter.hasNext() && !compatible) {
            Integer aType = aIter.next();
            Iterator<Integer> bIter = b.iterator();
            while (bIter.hasNext() && !compatible) {
                Integer bType = bIter.next();
                compatible = ExpressionTypeValidator.isConsistent(aType, bType);
            }
        }
        return compatible;
    }

    public static ExpressionType mostConcreteType(ExpressionType aType, ExpressionType bType) throws InvalidTypeException {
        if (aType == ExpressionType.ERROR) {
            return aType;
        }
        if (bType == ExpressionType.ERROR) {
            return bType;
        }
        if (aType == ExpressionType.UNKNOWN) {
            return bType;
        }
        if (bType == ExpressionType.UNKNOWN) {
            return aType;
        }
        if (aType == ExpressionType.NULL) {
            return bType;
        }
        if (bType == ExpressionType.NULL) {
            return aType;
        }
        if (aType != bType) {
            return ExpressionType.ERROR;
        }
        return aType;
    }
}

