/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ISimpleExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;

public class FormatExpression
extends Expression
implements ISimpleExpression {
    private IExpression m_subExpression;
    private IExpression m_formatId;

    public FormatExpression(IExpression expr, IExpression formatId) {
        this.m_subExpression = expr;
        this.m_formatId = formatId;
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        this.m_subExpression = this.m_subExpression.optimize(changed);
        this.m_formatId = this.m_formatId.optimize(changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append("_FORMAT(");
        this.appendHelper(buffer, this.m_subExpression, context);
        this.appendListSeparator(buffer, context);
        this.appendHelper(buffer, this.m_formatId, context);
        buffer.append(")");
    }

    @Override
    protected boolean needWrapping(IExpressionFragment fragment, ExpressionFragment.AppendContext context) {
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof FormatExpression)) {
            return false;
        }
        FormatExpression otherExpr = (FormatExpression)other;
        if (!this.m_subExpression.equals(otherExpr.m_subExpression)) {
            return false;
        }
        return this.m_formatId.equals(otherExpr.m_formatId);
    }

    @Override
    public int getNbSubExpressions() {
        return 2;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            return this.m_formatId;
        }
        return this.m_subExpression;
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            this.m_formatId = (IExpression)fragment;
        } else {
            this.m_subExpression = (IExpression)fragment;
        }
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.m_subExpression != null) {
            result ^= this.m_subExpression.hashCode();
        }
        if (this.m_formatId != null) {
            result ^= this.m_formatId.hashCode();
        }
        return result;
    }

    public IExpressionFragment getFormatId() {
        return this.m_formatId;
    }
}

