/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionList;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionType;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ISimpleExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvalidTypeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import java.util.Enumeration;

public class FunctionExpression
extends Expression
implements ISimpleExpression {
    private String name;
    private ExpressionList parameters;

    public FunctionExpression() {
    }

    public FunctionExpression(String name, ExpressionList parameters) {
        if (name == null) {
            throw new NullPointerException("name may not be null.");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters may not be null.");
        }
        this.name = name;
        this.parameters = parameters;
    }

    static boolean isQuotedString(String str) {
        int len = str.length();
        if (len < 2) {
            return false;
        }
        if (str.charAt(0) != '\"') {
            return false;
        }
        return str.charAt(len - 1) == '\"';
    }

    static String unquoteString(String str) {
        if (!FunctionExpression.isQuotedString(str)) {
            return str;
        }
        int len = str.length();
        return str.substring(1, len - 1);
    }

    private boolean isNameSame(FunctionExpression other) {
        String origName = FunctionExpression.unquoteString(this.name);
        String otherName = FunctionExpression.unquoteString(other.name);
        return origName.equals(otherName);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FunctionExpression)) {
            return false;
        }
        FunctionExpression o = (FunctionExpression)other;
        if (!this.isNameSame(o)) {
            return false;
        }
        return this.parameters.equals(o.parameters);
    }

    @Override
    public int getNbSubExpressions() {
        return this.parameters.getNbSubExpressions();
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        return this.parameters.getSubExpression(fragmentNb);
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        this.parameters.setSubExpression(fragmentNb, fragment);
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        this.parameters.optimize(changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append(this.name);
        buffer.append("(");
        this.appendHelper(buffer, this.parameters, context);
        buffer.append(")");
    }

    @Override
    protected boolean needWrapping(IExpressionFragment fragment, ExpressionFragment.AppendContext context) {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private int hashName() {
        String unquotedName = FunctionExpression.unquoteString(this.name);
        return unquotedName.hashCode();
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.name != null) {
            result = result << 1 ^ this.hashName();
        }
        if (this.parameters != null) {
            result = result << 1 ^ this.parameters.hashCode();
        }
        return result;
    }

    @Override
    public ExpressionType getType() throws InvalidTypeException {
        Enumeration<IExpression> subExprEnum = this.getSubExpressions();
        while (subExprEnum.hasMoreElements()) {
            IExpression sub = subExprEnum.nextElement();
            sub.getType();
        }
        return ExpressionType.UNKNOWN;
    }

    public IExpression getParameter(int index) throws ParseTreeException {
        return (IExpression)this.parameters.getSubExpression(index);
    }

    public ExpressionList getParameters() {
        return this.parameters;
    }
}

