/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.MapList;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NullExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;

public class LookupExpression
extends Expression {
    private IExpression lookupKey;
    private MapList lookupMap;
    private IExpression defaultValue;

    public LookupExpression(IExpression key, MapList mappings, IExpression defaultValue) {
        this.lookupKey = key;
        this.lookupMap = mappings;
        this.defaultValue = defaultValue;
    }

    @Override
    public int getNbSubExpressions() {
        return 3;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            return this.lookupKey;
        }
        if (fragmentNb == 1) {
            return this.lookupMap;
        }
        return this.defaultValue;
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            this.lookupKey = (IExpression)fragment;
        } else if (fragmentNb == 1) {
            this.lookupMap = (MapList)fragment;
        } else {
            this.defaultValue = (IExpression)fragment;
        }
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        this.lookupKey = this.lookupKey.optimize(changed);
        this.lookupMap.optimize(changed);
        this.defaultValue = this.defaultValue.optimize(changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append("LOOKUP ");
        this.appendHelper(buffer, this.lookupKey, context);
        buffer.append(" IN ");
        this.appendHelper(buffer, this.lookupMap, context);
        buffer.append(" DEFAULT ");
        this.appendHelper(buffer, this.defaultValue, context);
    }

    @Override
    protected boolean needWrapping(IExpressionFragment fragment, ExpressionFragment.AppendContext context) {
        return fragment != this.lookupKey && fragment != this.defaultValue || !(fragment instanceof NullExpression);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof LookupExpression)) {
            return false;
        }
        LookupExpression o = (LookupExpression)other;
        if (this.lookupKey != o.lookupKey && !this.lookupKey.equals(o.lookupKey)) {
            return false;
        }
        if (this.lookupMap != o.lookupMap && !this.lookupMap.equals(o.lookupMap)) {
            return false;
        }
        return this.defaultValue == o.defaultValue || this.defaultValue.equals(o.defaultValue);
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.lookupKey != null) {
            result ^= this.lookupKey.hashCode();
        }
        if (this.lookupMap != null) {
            result ^= this.lookupMap.hashCode();
        }
        if (this.defaultValue != null) {
            result ^= this.defaultValue.hashCode();
        }
        return result;
    }

    public IExpression getLookupKey() {
        return this.lookupKey;
    }

    public MapList getLookupMap() {
        return this.lookupMap;
    }

    public IExpression getDefaultValue() {
        return this.defaultValue;
    }
}

