/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Clause;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import java.util.Vector;

public class MapItem
extends Clause {
    private IExpression lookupKey;
    private IExpression rhs;

    public MapItem(IExpression lhs, IExpression rhs) {
        this.lookupKey = lhs;
        this.rhs = rhs;
    }

    void getSubExpressions(Vector<IExpression> v) {
        v.add(this.lookupKey);
        v.add(this.rhs);
    }

    @Override
    public int getNbSubExpressions() {
        return 2;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            return this.lookupKey;
        }
        return this.rhs;
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        if (fragmentNb == 0) {
            this.lookupKey = (IExpression)fragment;
        } else {
            this.rhs = (IExpression)fragment;
        }
    }

    @Override
    Clause optimize(BooleanValue changed) throws ParseTreeException {
        this.lookupKey = this.lookupKey.optimize(changed);
        this.rhs = this.rhs.optimize(changed);
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        this.appendHelper(buffer, this.lookupKey, context);
        buffer.append(" --> ");
        this.appendHelper(buffer, this.rhs, context);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lookupKey == null ? 0 : this.lookupKey.hashCode());
        result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapItem)) {
            return false;
        }
        MapItem other = (MapItem)obj;
        if (this.lookupKey == null ? other.lookupKey != null : !this.lookupKey.equals(other.lookupKey)) {
            return false;
        }
        return !(this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs));
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    public IExpression getLookupKey() {
        return this.lookupKey;
    }

    public IExpression getRhs() {
        return this.rhs;
    }
}

