/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ISimpleExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import java.util.Vector;

public class NameExpression
extends Expression
implements Comparable<NameExpression>,
ISimpleExpression {
    public Vector<String> m_identifiers = new Vector();

    public void add(String ident) {
        this.m_identifiers.add(ident);
    }

    public String getQueryName() {
        String id = null;
        if (this.m_identifiers.size() > 1) {
            id = this.m_identifiers.firstElement();
        }
        return id;
    }

    public String getDataItem() {
        String dataItem = this.m_identifiers.lastElement();
        return dataItem;
    }

    public int getNbParts() {
        return this.m_identifiers.size();
    }

    public String getPart(int i) {
        return this.m_identifiers.get(i);
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) {
        return this;
    }

    @Override
    public int getNbSubExpressions() {
        return 0;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        int nbIdentifiers = this.m_identifiers.size();
        if (nbIdentifiers == 0) {
            return;
        }
        buffer.append("[");
        String id = this.m_identifiers.get(0);
        buffer.append(id);
        for (int i = 1; i < nbIdentifiers; ++i) {
            buffer.append("].[");
            id = this.m_identifiers.get(i);
            buffer.append(id);
        }
        buffer.append("]");
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof NameExpression)) {
            return false;
        }
        NameExpression otherExpr = (NameExpression)other;
        int size = this.m_identifiers.size();
        if (size != otherExpr.m_identifiers.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            String b;
            String a = this.m_identifiers.get(i);
            if (a.equals(b = otherExpr.m_identifiers.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        for (int i = 0; i < this.m_identifiers.size(); ++i) {
            String id = this.m_identifiers.get(i);
            int hc = id.hashCode();
            result = result << 1 ^ hc;
        }
        return result;
    }

    @Override
    public int compareTo(NameExpression otherName) {
        int thisNbIdentifiers = this.m_identifiers.size();
        int otherNbIdentifiers = otherName.m_identifiers.size();
        int nbIdentifiers = otherNbIdentifiers > thisNbIdentifiers ? otherNbIdentifiers : thisNbIdentifiers;
        for (int i = 0; i < nbIdentifiers; ++i) {
            String otherIdentifier;
            if (i == thisNbIdentifiers) {
                return -1;
            }
            if (i == otherNbIdentifiers) {
                return 1;
            }
            String thisIdentifier = this.m_identifiers.get(i);
            int result = thisIdentifier.compareTo(otherIdentifier = otherName.m_identifiers.get(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

