/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.EqualityExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionType;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.FalseExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ISimpleExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvalidTypeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NotEqualsExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.TrueExpression;

public class NotExpression
extends Expression
implements ISimpleExpression {
    protected IExpression subExpression;

    public NotExpression(IExpression expr) {
        this.subExpression = expr;
    }

    @Override
    public int getNbSubExpressions() {
        return 1;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        return this.subExpression;
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.getNbSubExpressions()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        this.subExpression = (IExpression)fragment;
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        this.subExpression = this.subExpression.optimize(changed);
        if (this.subExpression instanceof NotExpression) {
            NotExpression sub = (NotExpression)this.subExpression;
            changed.set(true);
            return sub.subExpression;
        }
        if (this.subExpression instanceof TrueExpression) {
            changed.set(true);
            return FalseExpression.getInstance();
        }
        if (this.subExpression instanceof FalseExpression) {
            changed.set(true);
            return TrueExpression.getInstance();
        }
        if (this.subExpression instanceof NotEqualsExpression) {
            NotEqualsExpression sub = (NotEqualsExpression)this.subExpression;
            IExpression lhs = sub.getLhs();
            IExpression rhs = sub.getRhs();
            changed.set(true);
            return new EqualityExpression(lhs, rhs);
        }
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append("NOT ");
        this.appendHelper(buffer, this.subExpression, context);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof NotExpression)) {
            return false;
        }
        NotExpression o = (NotExpression)other;
        return this.subExpression == o.subExpression || this.subExpression.equals(o.subExpression);
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.subExpression != null) {
            result ^= this.subExpression.hashCode();
        }
        return result;
    }

    @Override
    public ExpressionType getType() throws InvalidTypeException {
        this.checkSubexpressionType(ExpressionType.BOOLEAN);
        return ExpressionType.BOOLEAN;
    }
}

