/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionType;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.FalseExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.InvalidTypeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.TrueExpression;
import java.util.Vector;

public class OrExpression
extends Expression {
    Vector<IExpression> m_subExpressions = new Vector();

    public void add(IExpression sub) {
        this.m_subExpressions.add(sub);
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        BooleanValue newChanged = new BooleanValue(false);
        do {
            IExpression ex;
            newChanged.set(false);
            OrExpression.optimizeExpressionSubtree(this.m_subExpressions, newChanged);
            int i = 0;
            while (i < this.m_subExpressions.size()) {
                ex = this.m_subExpressions.get(i);
                if (!(ex instanceof OrExpression)) {
                    ++i;
                    continue;
                }
                this.m_subExpressions.removeElementAt(i);
                OrExpression child = (OrExpression)ex;
                this.m_subExpressions.addAll(child.m_subExpressions);
                newChanged.set(true);
            }
            for (i = 0; i < this.m_subExpressions.size(); ++i) {
                ex = this.m_subExpressions.get(i);
                if (!(ex instanceof TrueExpression)) {
                    continue;
                }
                newChanged.set(true);
                return TrueExpression.getInstance();
            }
            for (i = 0; i < this.m_subExpressions.size(); ++i) {
                ex = this.m_subExpressions.get(i);
                int j = i + 1;
                while (j < this.m_subExpressions.size()) {
                    Expression other = (Expression)this.m_subExpressions.get(j);
                    if (ex.equals(other)) {
                        this.m_subExpressions.remove(j);
                        newChanged.set(true);
                        continue;
                    }
                    ++j;
                }
            }
            i = 0;
            while (i < this.m_subExpressions.size()) {
                ex = this.m_subExpressions.get(i);
                if (!(ex instanceof FalseExpression)) {
                    ++i;
                    continue;
                }
                newChanged.set(true);
                this.m_subExpressions.remove(i);
            }
            if (this.m_subExpressions.size() == 0) {
                changed.set(true);
                return FalseExpression.getInstance();
            }
            if (this.m_subExpressions.size() == 1) {
                changed.set(true);
                ex = this.m_subExpressions.get(0);
                return ex;
            }
            if (!newChanged.get()) continue;
            changed.set(true);
        } while (newChanged.get());
        return this;
    }

    @Override
    public int getNbSubExpressions() {
        return this.m_subExpressions.size();
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.m_subExpressions.size()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        return this.m_subExpressions.get(fragmentNb);
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (fragmentNb < 0 || fragmentNb >= this.m_subExpressions.size()) {
            throw new ParseTreeException("fragmentNb out of bounds.");
        }
        this.m_subExpressions.set(fragmentNb, (IExpression)fragment);
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        int nb = this.m_subExpressions.size();
        for (int i = 0; i < nb; ++i) {
            if (i != 0) {
                buffer.append(" OR ");
            }
            IExpression expr = this.m_subExpressions.get(i);
            this.appendHelper(buffer, expr, context);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OrExpression)) {
            return false;
        }
        OrExpression otherExpr = (OrExpression)other;
        return OrExpression.sameSetHelper(this.m_subExpressions, otherExpr.m_subExpressions);
    }

    @Override
    public int hashCode() {
        int a = this.getClass().hashCode();
        int b = this.m_subExpressions.hashCode();
        int result = a ^ b;
        return result;
    }

    @Override
    public ExpressionType getType() throws InvalidTypeException {
        this.checkSubexpressionType(ExpressionType.BOOLEAN);
        return ExpressionType.BOOLEAN;
    }
}

