/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Expression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.WhenClauses;

public class SimpleCaseExpression
extends Expression {
    private IExpression expr;
    private WhenClauses whenClauses;
    private IExpression elseExpr;

    public SimpleCaseExpression(IExpression expr, WhenClauses whenClauses, IExpression elseExpr) {
        this.expr = expr;
        this.whenClauses = whenClauses;
        this.elseExpr = elseExpr;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleCaseExpression)) {
            return false;
        }
        SimpleCaseExpression o = (SimpleCaseExpression)other;
        if (this.expr != o.expr && !this.expr.equals(o.expr)) {
            return false;
        }
        if (this.whenClauses != o.whenClauses && !this.whenClauses.equals(o.whenClauses)) {
            return false;
        }
        return this.elseExpr == o.elseExpr || this.elseExpr.equals(o.elseExpr);
    }

    @Override
    public int getNbSubExpressions() {
        int nbSubExpressions = 0;
        if (this.expr != null) {
            ++nbSubExpressions;
        }
        if (this.whenClauses != null) {
            ++nbSubExpressions;
        }
        if (this.elseExpr != null) {
            ++nbSubExpressions;
        }
        return nbSubExpressions;
    }

    @Override
    public IExpressionFragment getSubExpression(int fragmentNb) throws ParseTreeException {
        if (this.expr != null) {
            if (fragmentNb == 0) {
                return this.expr;
            }
            --fragmentNb;
        }
        if (this.whenClauses != null) {
            if (fragmentNb == 0) {
                return this.whenClauses;
            }
            --fragmentNb;
        }
        if (this.elseExpr != null) {
            if (fragmentNb == 0) {
                return this.elseExpr;
            }
            --fragmentNb;
        }
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public void setSubExpression(int fragmentNb, IExpressionFragment fragment) throws ParseTreeException {
        if (this.expr != null) {
            if (fragmentNb == 0) {
                this.expr = (IExpression)fragment;
                return;
            }
            --fragmentNb;
        }
        if (this.whenClauses != null) {
            if (fragmentNb == 0) {
                this.whenClauses = (WhenClauses)fragment;
                return;
            }
            --fragmentNb;
        }
        if (this.elseExpr != null) {
            if (fragmentNb == 0) {
                this.elseExpr = (IExpression)fragment;
                return;
            }
            --fragmentNb;
        }
        throw new ParseTreeException("fragmentNb out of bounds.");
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public IExpression optimize(BooleanValue changed) throws ParseTreeException {
        this.expr = this.expr.optimize(changed);
        this.whenClauses.optimize(changed);
        if (this.elseExpr != null) {
            this.elseExpr = this.elseExpr.optimize(changed);
        }
        return this;
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append("CASE ");
        this.appendHelper(buffer, this.expr, context);
        buffer.append(" ");
        this.appendHelper(buffer, this.whenClauses, context);
        if (this.elseExpr != null) {
            buffer.append(" ELSE ");
            this.appendHelper(buffer, this.elseExpr, context);
        }
        buffer.append(" END ");
    }

    @Override
    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.expr != null) {
            result ^= this.expr.hashCode();
        }
        if (this.whenClauses != null) {
            result ^= this.whenClauses.hashCode();
        }
        if (this.elseExpr != null) {
            result ^= this.elseExpr.hashCode();
        }
        return result;
    }

    public IExpression getExpr() {
        return this.expr;
    }

    public WhenClauses getWhenClauses() {
        return this.whenClauses;
    }

    public IExpression getElseExpr() {
        return this.elseExpr;
    }
}

