/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.expressionparser.parsetree;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionFragment;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ExpressionLocale;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NumericLiteralExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeVisitor;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.Type;
import java.util.Locale;

public class TypeLen
implements Type {
    private String type;
    private NumericLiteralExpression typeLength;
    private NumericLiteralExpression scale;

    public TypeLen(String type, NumericLiteralExpression typeLength, NumericLiteralExpression scale) {
        this.type = type;
        this.typeLength = typeLength;
        this.scale = scale;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeLen)) {
            return false;
        }
        TypeLen o = (TypeLen)other;
        if (this.type != o.type && !this.type.equals(o.type)) {
            return false;
        }
        if (this.typeLength != o.typeLength && !this.typeLength.equals(o.typeLength)) {
            return false;
        }
        return this.scale == o.scale || this.scale.equals(o.scale);
    }

    @Override
    public void callVisitor(ParseTreeVisitor visitor) throws ParseTreeException {
        visitor.accept(this);
    }

    @Override
    public void appendTo(StringBuffer buffer, ExpressionFragment.AppendContext context) {
        buffer.append(this.type);
        if (this.typeLength != null) {
            buffer.append("(");
            this.typeLength.appendTo(buffer, context);
            if (this.scale != null) {
                Locale locale = context.getLocale();
                buffer.append(ExpressionLocale.getListSeparator(locale));
                this.scale.appendTo(buffer, context);
            }
            buffer.append(")");
        }
    }

    public String getType() {
        return this.type;
    }

    public NumericLiteralExpression getTypeLength() {
        return this.typeLength;
    }

    public NumericLiteralExpression getScale() {
        return this.scale;
    }
}

