/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PositionFilterReader
extends FilterReader {
    private Position currentPosition = new Position();
    private Position markedPosition = null;

    public PositionFilterReader(Reader in) {
        super(in);
    }

    @Override
    public synchronized int read() throws IOException {
        int c = super.read();
        if (c == -1) {
            return c;
        }
        ++this.currentPosition.characterNumber;
        if (c == 10) {
            ++this.currentPosition.lineNumber;
            this.currentPosition.columnNumber = 0;
        } else {
            ++this.currentPosition.columnNumber;
        }
        return c;
    }

    @Override
    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        int charsRead;
        for (charsRead = 0; charsRead < len; ++charsRead) {
            int c = this.read();
            if (c == -1) {
                if (charsRead == 0) {
                    return -1;
                }
                return charsRead;
            }
            cbuf[off + charsRead] = (char)c;
        }
        return charsRead;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        long charactersSkipped;
        for (charactersSkipped = 0L; charactersSkipped < n; ++charactersSkipped) {
            int c = this.read();
            if (c != -1) continue;
            return charactersSkipped;
        }
        return charactersSkipped;
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.markedPosition = (Position)this.currentPosition.clone();
        super.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        if (this.markedPosition != null) {
            this.currentPosition = (Position)this.markedPosition.clone();
        } else {
            this.currentPosition.characterNumber = 0;
            this.currentPosition.lineNumber = 1;
            this.currentPosition.columnNumber = 0;
        }
        super.reset();
    }

    public int getLineNumber() {
        return this.currentPosition.lineNumber;
    }

    public int getColumnNumber() {
        return this.currentPosition.columnNumber;
    }

    public int getCharacterNumber() {
        return this.currentPosition.characterNumber;
    }

    class Position
    implements Cloneable {
        int lineNumber = 1;
        int columnNumber = 0;
        int characterNumber = 0;

        Position() {
        }

        public Object clone() {
            Position theClone = new Position();
            theClone.lineNumber = this.lineNumber;
            theClone.columnNumber = this.columnNumber;
            theClone.characterNumber = this.characterNumber;
            return theClone;
        }
    }
}

