/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.io;

import com.cognos.rspecupgrade.internal.io.IOException;
import com.cognos.rspecupgrade.internal.io.NodeListListImpl;
import com.cognos.rspecupgrade.internal.io.PositionFilterReader;
import com.cognos.rspecupgrade.internal.io.UTFDataFormatException;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.Configuration;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContextImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static final String xmlNamespace = "http://www.w3.org/XML/1998/namespace";
    public static final String xmlPrefix = "xml";
    public static final String xmlnsNamespace = "http://www.w3.org/2000/xmlns/";
    public static final String xmlnsPrefix = "xmlns";

    public static Document createDocument() throws IOException {
        try {
            Document document;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document2 = document = builder.newDocument();
            return document2;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document createDocumentWithDtd(String root, String namespace, String dtdPath) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImplementation = builder.getDOMImplementation();
            DocumentType docType = domImplementation.createDocumentType(root, "SYSTEM", dtdPath);
            Document document = domImplementation.createDocument(namespace, root, docType);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (DOMException e) {
            throw new IOException(e);
        }
    }

    public static Document createDocumentWithDtd(String root, String namespace, File dtd) throws IOException, java.io.IOException {
        URI dtdUri = dtd.toURI();
        URL dtdUrl = dtdUri.toURL();
        String dtdUrlString = dtdUrl.toString();
        return XmlUtils.createDocumentWithDtd(root, namespace, dtdUrlString);
    }

    public static Document readDocument(File in) throws IOException {
        try {
            return XmlUtils.readDocument(in.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            throw new IOException(ex);
        }
    }

    public static Document readDocument(URL in) throws IOException {
        try {
            String encoding = "UTF-8";
            InputStreamReader reader = new InputStreamReader(in.openStream(), "UTF-8");
            return XmlUtils.readDocument(reader);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException(ex);
        }
        catch (java.io.IOException ex) {
            throw new IOException(ex);
        }
    }

    public static Document readDocument(InputStream in) throws IOException {
        String encoding = "UTF-8";
        return XmlUtils.readDocument(in, "UTF-8");
    }

    public static Document readDocument(InputStream in, String encoding) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(in, encoding);
            Document document = XmlUtils.readDocument(reader);
            return document;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException(ex);
        }
    }

    public static Document readDocument(Reader in) throws IOException {
        if (in == null) {
            throw new IOException("Input stream may not be null");
        }
        PositionFilterReader posFilter = new PositionFilterReader(in);
        try {
            Document document = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource src = new InputSource(posFilter);
            document = builder.parse(src);
            return document;
        }
        catch (java.io.UTFDataFormatException ex) {
            UTFDataFormatException dataException = new UTFDataFormatException(ex);
            dataException.setLineNumber(posFilter.getLineNumber());
            dataException.setColumnNumber(posFilter.getColumnNumber());
            dataException.setCharacterNumber(posFilter.getCharacterNumber());
            throw dataException;
        }
        catch (java.io.IOException ex) {
            IOException dataException = new IOException(ex);
            dataException.setLineNumber(posFilter.getLineNumber());
            dataException.setColumnNumber(posFilter.getColumnNumber());
            dataException.setCharacterNumber(posFilter.getCharacterNumber());
            throw dataException;
        }
        catch (ParserConfigurationException ex) {
            IOException dataException = new IOException(ex);
            dataException.setLineNumber(posFilter.getLineNumber());
            dataException.setColumnNumber(posFilter.getColumnNumber());
            dataException.setCharacterNumber(posFilter.getCharacterNumber());
            throw dataException;
        }
        catch (SAXException ex) {
            IOException dataException = new IOException(ex);
            dataException.setLineNumber(posFilter.getLineNumber());
            dataException.setColumnNumber(posFilter.getColumnNumber());
            dataException.setCharacterNumber(posFilter.getCharacterNumber());
            throw dataException;
        }
        catch (Throwable ex) {
            IOException dataException = new IOException(ex);
            dataException.setLineNumber(posFilter.getLineNumber());
            dataException.setColumnNumber(posFilter.getColumnNumber());
            dataException.setCharacterNumber(posFilter.getCharacterNumber());
            throw dataException;
        }
    }

    public static void writeDocument(File out, Node document) throws Exception {
        XmlUtils.writeDocument(out, document, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(File out, Node document, boolean indent) throws Exception {
        FileOutputStream outFileStream = new FileOutputStream(out);
        OutputStreamWriter outStreamWriter = new OutputStreamWriter((OutputStream)outFileStream, "UTF-8");
        BufferedWriter bufferedWriter = new BufferedWriter(outStreamWriter);
        try {
            XmlUtils.writeDocument(bufferedWriter, document, indent);
        }
        finally {
            outFileStream.close();
        }
    }

    public static void writeDocument(Writer out, Node document) throws Exception {
        XmlUtils.writeDocument(out, document, false);
    }

    private static void setDocTypeFlag(Transformer transformer, Node node) {
        if (!(node instanceof Document)) {
            return;
        }
        Document doc = (Document)node;
        DocumentType docType = doc.getDoctype();
        if (docType == null) {
            return;
        }
        String systemId = docType.getSystemId();
        if (systemId != null) {
            transformer.setOutputProperty("doctype-system", systemId);
        }
    }

    public static void writeDocument(Writer out, Node node, boolean indent) throws Exception {
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(out);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", indent ? "yes" : "no");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        XmlUtils.setDocTypeFlag(transformer, node);
        transformer.transform(source, result);
    }

    public static void writeDocument(OutputStream out, Node document, boolean indent) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        Node node = document;
        XmlUtils.writeDocument(writer, node, indent);
    }

    public static String toString(Node node) throws Exception {
        StringWriter writer = new StringWriter();
        XmlUtils.writeDocument(writer, node);
        writer.close();
        return writer.toString();
    }

    public static void writeIntermediateDocument(Node document, String footer, IConfiguration config) {
        try {
            File file = config.getIntermediateFileName(footer, xmlPrefix);
            if (file != null) {
                FileOutputStream outFileStream = new FileOutputStream(file);
                OutputStreamWriter outStreamWriter = new OutputStreamWriter((OutputStream)outFileStream, "UTF-8");
                BufferedWriter bufferedWriter = new BufferedWriter(outStreamWriter);
                if (document != null) {
                    XmlUtils.writeDocument(bufferedWriter, document, true);
                }
                if (footer != null) {
                    bufferedWriter.write("<!-- " + footer + " -->");
                }
                bufferedWriter.close();
                outStreamWriter.close();
                outFileStream.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Element getAncestorElement(Node node) {
        if (node instanceof Attr) {
            Attr attr = (Attr)node;
            return attr.getOwnerElement();
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return null;
        }
        if (parent instanceof Element) {
            return (Element)parent;
        }
        return XmlUtils.getAncestorElement(parent);
    }

    public static Element getAncestorElement(Element descendant, String elementName) {
        if (descendant == null) {
            return null;
        }
        Node parent = descendant.getParentNode();
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof Element)) {
            return null;
        }
        Element parentElement = descendant;
        return XmlUtils.getAncestorOrSelfElement(parentElement, elementName);
    }

    public static Element getAncestorOrSelfElement(Element descendant, String elementName) {
        return XmlUtils.getAncestorOrSelfElement(descendant, elementName, null);
    }

    public static Element getAncestorOrSelfElement(Element descendant, String elementName, Element constraint) {
        while (descendant != constraint) {
            String descendantName = XmlUtils.getName(descendant);
            if (elementName.equals(descendantName)) {
                return descendant;
            }
            Node parent = descendant.getParentNode();
            if (parent == null) {
                return null;
            }
            if (!(parent instanceof Element)) {
                return null;
            }
            descendant = (Element)parent;
        }
        return descendant;
    }

    public static String getText(Node parent) {
        StringBuffer buffer = new StringBuffer();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            String string;
            Text text;
            if (child.getNodeType() == 3) {
                text = (Text)child;
                string = text.getData();
                buffer.append(string);
                continue;
            }
            if (child.getNodeType() != 4) continue;
            text = (CDATASection)child;
            string = text.getData();
            buffer.append(string);
        }
        String result = buffer.toString();
        return result;
    }

    public static void setText(Element element, String text) {
        Node child;
        do {
            if ((child = element.getFirstChild()) == null) continue;
            element.removeChild(child);
        } while (child != null);
        Document doc = element.getOwnerDocument();
        child = doc.createTextNode(text);
        element.appendChild(child);
    }

    public static Element getRoot(Document doc) {
        for (Node child = doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element result = (Element)child;
            return result;
        }
        return null;
    }

    public static NodeList getElementsWithAttribute(Element fromElement, String attributeName) throws NullPointerException {
        if (fromElement == null) {
            throw new NullPointerException("Parent may not be null");
        }
        if (attributeName == null) {
            throw new NullPointerException("Attribute name may not be null");
        }
        NodeListListImpl result = new NodeListListImpl();
        XmlUtils.getElementsWithAttribute(result, fromElement, attributeName);
        return result;
    }

    private static void getElementsWithAttribute(NodeListListImpl nodeList, Element fromElement, String attributeName) throws NullPointerException {
        if (fromElement.hasAttribute(attributeName)) {
            nodeList.add(fromElement);
        }
        for (Node child = fromElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element elem = (Element)child;
            XmlUtils.getElementsWithAttribute(nodeList, elem, attributeName);
        }
    }

    public static NodeList getChildElements(Node parent) throws NullPointerException {
        if (parent == null) {
            throw new NullPointerException("Parent may not be null");
        }
        NodeListListImpl result = new NodeListListImpl();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element elem = (Element)child;
            result.add(elem);
        }
        return result;
    }

    public static Element getChildElement(Node parent) {
        Element result = null;
        Node child = parent.getFirstChild();
        if ((child = XmlUtils.skipBlankTextAndComments(child)) != null && child instanceof Element) {
            Node sibling = child.getNextSibling();
            if ((sibling = XmlUtils.skipBlankTextAndComments(sibling)) == null) {
                result = (Element)child;
            }
        }
        return result;
    }

    public static NodeList getChildElementsByName(Node parent, String elementName) throws NullPointerException {
        if (parent == null) {
            throw new NullPointerException("Parent may not be null");
        }
        if (elementName == null) {
            throw new NullPointerException("elementName may not be null");
        }
        NodeListListImpl result = new NodeListListImpl();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element elem;
            String elemName;
            if (!(child instanceof Element) || !(elemName = XmlUtils.getName(elem = (Element)child)).equals(elementName)) continue;
            result.add(elem);
        }
        return result;
    }

    public static Element getFirstChildElement(Node parent) {
        Node child;
        if (parent == null) {
            throw new NullPointerException("parent may not be null");
        }
        for (child = parent.getFirstChild(); child != null && !(child instanceof Element); child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public static Element getFirstChildElementByName(Node parent, String name) {
        if (parent == null) {
            throw new NullPointerException("parent may not be null");
        }
        if (name == null) {
            throw new NullPointerException("name may not be null");
        }
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childElement;
            String childName;
            if (!(child instanceof Element) || !(childName = XmlUtils.getName(childElement = (Element)child)).equals(name)) continue;
            return childElement;
        }
        return null;
    }

    public static Element getFirstChildElementByNameWithAttributeValue(Node parent, String elementName, String attributeName, String attributeValue) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            String value;
            Element childElement;
            String name;
            if (child.getNodeType() != 1 || !(name = XmlUtils.getName(childElement = (Element)child)).equals(elementName) || !childElement.hasAttribute(attributeName) || !(value = childElement.getAttribute(attributeName)).equals(attributeValue)) continue;
            return childElement;
        }
        return null;
    }

    public static Element getLastChildElementByName(Node parent, String elementName) {
        if (parent == null) {
            throw new NullPointerException("parent may not be null");
        }
        for (Node child = parent.getLastChild(); child != null; child = child.getPreviousSibling()) {
            Element childElement;
            String name;
            if (!(child instanceof Element) || !(name = XmlUtils.getName(childElement = (Element)child)).equals(elementName)) continue;
            return childElement;
        }
        return null;
    }

    public static Element getLastChildElement(Node parent) {
        Node child;
        if (parent == null) {
            throw new NullPointerException("parent may not be null");
        }
        for (child = parent.getLastChild(); child != null && !(child instanceof Element); child = child.getPreviousSibling()) {
        }
        return (Element)child;
    }

    public static Element getOrCreateChildElementByName(Node parent, String elementName) {
        Element child = XmlUtils.getFirstChildElementByName(parent, elementName);
        if (child == null) {
            Document doc = XmlUtils.getOwnerDoc(parent);
            child = XmlUtils.createElement(doc, elementName);
            parent.appendChild(child);
        }
        return child;
    }

    public static Element getNextSiblingElement(Node sibling) {
        if (sibling == null) {
            throw new NullPointerException("sibling may not be null");
        }
        while ((sibling = sibling.getNextSibling()) != null && !(sibling instanceof Element)) {
        }
        return (Element)sibling;
    }

    public static Element getPreviousSiblingElement(Node sibling) {
        if (sibling == null) {
            throw new NullPointerException("sibling may not be null");
        }
        while ((sibling = sibling.getPreviousSibling()) != null && !(sibling instanceof Element)) {
        }
        return (Element)sibling;
    }

    public static Element getPreviousSiblingByName(Node sibling, String elementName) {
        if (sibling == null) {
            throw new NullPointerException("sibling may not be null");
        }
        while ((sibling = sibling.getPreviousSibling()) != null && !(sibling instanceof Element) && !elementName.equals(XmlUtils.getName((Element)sibling))) {
        }
        return (Element)sibling;
    }

    public static Element getElementWithId(Document doc, String id) {
        return XmlUtils.getElementWithAttributeValue(doc, "id", id);
    }

    public static Element getElementWithAttributeValue(Document doc, String attName, String attValue) {
        Element rootElement = XmlUtils.getRoot(doc);
        if (rootElement != null) {
            return XmlUtils.getElementWithAttributeValue(rootElement, attName, attValue);
        }
        return null;
    }

    public static Element getParentElement(Node node) {
        Node parent = node.getParentNode();
        if (parent instanceof Element) {
            return (Element)parent;
        }
        return null;
    }

    public static void removeNodeFromParent(Node child) {
        Node parent = child.getParentNode();
        parent.removeChild(child);
    }

    public static void removeChild(Element parent, String childName) {
        Element child = XmlUtils.getFirstChildElementByName(parent, childName);
        if (child != null) {
            parent.removeChild(child);
        }
    }

    public static void removeChildren(Node node) {
        Node child;
        do {
            if ((child = node.getFirstChild()) == null) continue;
            node.removeChild(child);
        } while (child != null);
    }

    public static Node skipBlankText(Node docNode) {
        while (docNode != null && docNode instanceof Text) {
            Text textNode = (Text)docNode;
            String textContent = textNode.getData();
            if (textContent != null) {
                textContent = textContent.trim();
            }
            if (textContent != null && textContent.length() != 0) break;
            docNode = docNode.getNextSibling();
        }
        return docNode;
    }

    public static Node skipComments(Node node) {
        while (node != null && node instanceof Comment) {
            node = node.getNextSibling();
        }
        return node;
    }

    public static Node skipBlankTextAndComments(Node docNode) {
        Node oldNode = null;
        while (docNode != oldNode) {
            oldNode = docNode;
            docNode = XmlUtils.skipBlankText(docNode);
            docNode = XmlUtils.skipComments(docNode);
        }
        return docNode;
    }

    public static void delete(Node node) {
        Node parent = node.getParentNode();
        parent.removeChild(node);
    }

    public static void commentOut(Node node, String msg) {
        try {
            StringWriter removedNodeWriter = new StringWriter();
            if (msg != null) {
                removedNodeWriter.write(msg);
            }
            XmlUtils.writeDocument(removedNodeWriter, node);
            removedNodeWriter.close();
            String removedNodeText = removedNodeWriter.toString();
            XmlUtils.insertComment(node, removedNodeText);
        }
        catch (Exception removedNodeWriter) {
            // empty catch block
        }
        if (node instanceof Attr) {
            Attr attr = (Attr)node;
            Element owner = attr.getOwnerElement();
            owner.removeAttributeNode(attr);
        } else {
            Node parent = node.getParentNode();
            parent.removeChild(node);
        }
    }

    public static void insertComment(Node node, String msg) {
        int msgLength = msg.length();
        StringBuffer buffer = new StringBuffer(msgLength);
        int previousChar = -1;
        for (int i = 0; i < msgLength; ++i) {
            char c = msg.charAt(i);
            if (c == '-' && previousChar == 45) {
                buffer.append("&#x002D;");
            } else {
                buffer.append(c);
            }
            previousChar = c;
        }
        String fixedMsg = buffer.toString();
        Document doc = XmlUtils.getOwnerDoc(node);
        Comment comment = doc.createComment(fixedMsg);
        Element elem = XmlUtils.findElement(node);
        Node parent = elem == null ? doc : elem.getParentNode();
        parent.insertBefore(comment, elem);
    }

    private static Element findElement(Node node) {
        while (node != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            if (node instanceof Attr) {
                Attr attr = (Attr)node;
                node = attr.getOwnerElement();
                continue;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static Document getOwnerDoc(Node node) {
        Document doc = node instanceof Document ? (Document)node : node.getOwnerDocument();
        return doc;
    }

    public static Element getElementWithAttributeValue(Element elem, String attName, String attValue) {
        if (elem != null) {
            String value;
            if (elem.hasAttribute(attName) && (value = elem.getAttribute(attName)).equals(attValue)) {
                return elem;
            }
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                Element childElement;
                Element found;
                if (!(child instanceof Element) || (found = XmlUtils.getElementWithAttributeValue(childElement = (Element)child, attName, attValue)) == null) continue;
                return found;
            }
        }
        return null;
    }

    public static Element getNamedElementWithAttributeValue(Element elem, String elemName, String attName, String attValue) {
        if (elem != null) {
            String value;
            if (XmlUtils.getName(elem).equals(elemName) && elem.hasAttribute(attName) && (value = elem.getAttribute(attName)).equals(attValue)) {
                return elem;
            }
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                Element childElement;
                Element found;
                if (!(child instanceof Element) || (found = XmlUtils.getNamedElementWithAttributeValue(childElement = (Element)child, elemName, attName, attValue)) == null) continue;
                return found;
            }
        }
        return null;
    }

    public static Element findOrAddChildElement(Element parent, String strNamespace, String strNewElementName) {
        Element childElement = XmlUtils.getFirstChildElementByName(parent, strNewElementName);
        if (childElement == null) {
            Document doc = parent.getOwnerDocument();
            childElement = doc.createElementNS(strNamespace, strNewElementName);
            parent.appendChild(childElement);
        }
        return childElement;
    }

    public static void addAttributeIfMissing(Element element, String strAttributeName, String strAttributeValue) {
        if (!element.hasAttribute(strAttributeName)) {
            element.setAttribute(strAttributeName, strAttributeValue);
        }
    }

    public static boolean hasAttribute(Element element, String attribute) {
        Attr attr = element.getAttributeNode(attribute);
        return attr != null && attr.getSpecified();
    }

    public static void copyAttributes(Element dest, Element src) {
        NamedNodeMap attributes = src.getAttributes();
        int nbItems = attributes.getLength();
        for (int i = nbItems - 1; i >= 0; --i) {
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            String value = attr.getValue();
            dest.setAttribute(name, value);
        }
    }

    public static void copyAttribute(String attribute, Element dest, Element src) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(attribute);
        XmlUtils.copyAttributes(attributes, dest, src);
    }

    public static void copyAttributes(List<String> attributes, Element dest, Element src) {
        for (String attribute : attributes) {
            Attr attr = src.getAttributeNode(attribute);
            if (attr == null || !attr.getSpecified()) continue;
            String name = attr.getName();
            String value = attr.getValue();
            dest.setAttribute(name, value);
        }
    }

    public static void moveChildren(final Element dest, Element src) throws XmlException {
        DomWalker.Examiner examiner = new DomWalker.Examiner(){

            @Override
            public DomWalker.SearchOrder examine(Element elem) {
                dest.appendChild(elem);
                return DomWalker.SearchOrder.proceed;
            }
        };
        DomWalker.walkChildrenElements(src, examiner);
    }

    public static Element createElement(Document doc, String localName) {
        Element root = XmlUtils.getRoot(doc);
        String namespace = root.getNamespaceURI();
        Element result = doc.createElementNS(namespace, localName);
        return result;
    }

    public static Element createChildElement(Element parent, String localName) {
        String namespace = parent.getNamespaceURI();
        Document doc = parent.getOwnerDocument();
        Element newChild = doc.createElementNS(namespace, localName);
        parent.appendChild(newChild);
        return newChild;
    }

    public static Element createSiblingElement(Element sibling, String localName) {
        String namespace = sibling.getNamespaceURI();
        Document doc = sibling.getOwnerDocument();
        Element newSibling = doc.createElementNS(namespace, localName);
        sibling.getParentNode().insertBefore(newSibling, sibling);
        return newSibling;
    }

    public static String getName(Node node) {
        String name = node.getLocalName();
        if (name == null) {
            name = node.getNodeName();
        }
        return name;
    }

    public static void cloneChildren(Element target, Element source) {
        for (Node child = source.getFirstChild(); child != null; child = child.getNextSibling()) {
            target.appendChild(child.cloneNode(true));
        }
    }

    private static String getNameSpaceUriForPrefix(String prefix, Element element) {
        if (prefix.equals(xmlPrefix)) {
            return xmlNamespace;
        }
        if (prefix.equals(xmlnsPrefix)) {
            return xmlnsNamespace;
        }
        while (element != null) {
            Attr attr = null;
            attr = prefix.length() == 0 ? element.getAttributeNode(xmlnsPrefix) : element.getAttributeNode("xmlns:" + prefix);
            if (attr != null) {
                return attr.getValue();
            }
            element = XmlUtils.getParentElement(element);
        }
        return null;
    }

    public static String getNameSpaceUriForPrefix(String prefix, Node node) {
        Element element = node instanceof Element ? (Element)node : XmlUtils.getAncestorElement(node);
        return XmlUtils.getNameSpaceUriForPrefix(prefix, element);
    }

    public static SchemaModel getSchema(Document xmlDoc, Messages messages) throws Exception {
        UpgradeSessionContextImpl session = new UpgradeSessionContextImpl(messages, new Configuration(messages));
        Element root = XmlUtils.getRoot(xmlDoc);
        String ns = root.getNamespaceURI();
        SchemaModel schemaModel = session.getReportSpecificationSchemaModel(ns);
        return schemaModel;
    }

    public static NodeList selectNodeList(Node node, String path, NamespaceContext nsResolver) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(nsResolver);
        XPathExpression xpr = xPath.compile(path);
        return (NodeList)xpr.evaluate(node, XPathConstants.NODESET);
    }
}

