/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.io;

import com.cognos.rspecupgrade.internal.io.IOException;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.LinkedList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlValidater {
    private static void copyChildren(Document source, Document destination) {
        for (Node sourceChild = source.getFirstChild(); sourceChild != null; sourceChild = sourceChild.getNextSibling()) {
            Node destinationChild = destination.importNode(sourceChild, true);
            destination.appendChild(destinationChild);
        }
    }

    static Document ensureDocTypeSet(Document doc, String dtdUrl) throws IOException {
        DocumentType docType = doc.getDoctype();
        if (docType != null) {
            return doc;
        }
        Element root = XmlUtils.getRoot(doc);
        Document modifiedDoc = XmlUtils.createDocumentWithDtd(root.getLocalName(), root.getNamespaceURI(), dtdUrl);
        modifiedDoc.removeChild(XmlUtils.getRoot(modifiedDoc));
        XmlValidater.copyChildren(doc, modifiedDoc);
        return modifiedDoc;
    }

    public static void validateDtd(Document srcDoc, String dtdUrl, LinkedList<String> warnings, LinkedList<String> errors, IConfiguration config) throws Exception {
        Document docWithTypeSet = XmlValidater.ensureDocTypeSet(srcDoc, dtdUrl);
        StringWriter writer = new StringWriter();
        XmlUtils.writeDocument(writer, (Node)docWithTypeSet);
        writer.close();
        String docString = writer.toString();
        byte[] docBytes = docString.getBytes("UTF-8");
        ByteArrayInputStream docInputStream = new ByteArrayInputStream(docBytes);
        InputSource input = new InputSource(docInputStream);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/validation", true);
        factory.setFeature("http://xml.org/sax/features/namespaces", true);
        SAXParser parser = factory.newSAXParser();
        Validator handler = new Validator(warnings, errors);
        parser.parse(input, (DefaultHandler)handler);
    }

    public static void validateSchema(Document doc, String schemaUrl, LinkedList<String> warnings, LinkedList<String> errors) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/validation", true);
        factory.setFeature("http://apache.org/xml/features/validation/schema", true);
        factory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        SAXParser parser = factory.newSAXParser();
        String encodedUrl = XmlValidater.encodeSpaces(schemaUrl);
        parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://developer.cognos.com/schemas/report/2.0/ " + encodedUrl);
        Validator handler = new Validator(warnings, errors);
        StringWriter writer = new StringWriter();
        XmlUtils.writeDocument(writer, (Node)doc);
        writer.close();
        String docString = writer.toString();
        byte[] docBytes = docString.getBytes("UTF-8");
        ByteArrayInputStream v5InputStream = new ByteArrayInputStream(docBytes);
        InputSource input = new InputSource(v5InputStream);
        parser.parse(input, (DefaultHandler)handler);
    }

    private static String encodeSpaces(String inputString) throws Exception {
        StringBuffer buf = new StringBuffer();
        int endPos = inputString.length();
        for (int curPos = 0; curPos < endPos; ++curPos) {
            char curChar = inputString.charAt(curPos);
            if (curChar == ' ') {
                buf.append("%20");
                continue;
            }
            buf.append(curChar);
        }
        return buf.toString();
    }

    private static class Validator
    extends DefaultHandler {
        LinkedList<String> warnings;
        LinkedList<String> errors;

        public Validator(LinkedList<String> warnings, LinkedList<String> errors) {
            this.warnings = warnings;
            this.errors = errors;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.errors.addLast(exception.getLocalizedMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.errors.addLast(exception.getLocalizedMessage());
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.warnings.addLast(exception.getLocalizedMessage());
        }
    }
}

