/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.queryfinder;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NameExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.RefDataItem;
import com.cognos.rspecupgrade.internal.io.NodeListListImpl;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.queryfinder.QueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeringQueryFinder
implements QueryFinder {
    public static Element findQuery(Element layoutElement) {
        String queryName = BeringQueryFinder.findQueryName(layoutElement);
        if (queryName == null) {
            return null;
        }
        Document document = layoutElement.getOwnerDocument();
        Element report = XmlUtils.getFirstChildElementByName(document, ReportSpecification20._report);
        Element queries = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._queries);
        if (queries == null) {
            return null;
        }
        Element query = XmlUtils.getFirstChildElementByNameWithAttributeValue(queries, ReportSpecification20._query, ReportSpecification20._name, queryName);
        return query;
    }

    public static Element findRefQueryElement(Element layoutElement) {
        if (layoutElement == null) {
            return null;
        }
        if (layoutElement.hasAttribute(ReportSpecification20._refQuery)) {
            return layoutElement;
        }
        Node parent = layoutElement.getParentNode();
        if (parent.getNodeType() != 1) {
            return null;
        }
        layoutElement = (Element)parent;
        return BeringQueryFinder.findRefQueryElement(layoutElement);
    }

    public static Element findRefQueryElement(Element layoutElement, String name) {
        while (layoutElement != null) {
            Element refQueryElem = BeringQueryFinder.findRefQueryElement(layoutElement);
            if (refQueryElem == null) {
                return null;
            }
            String queryName = refQueryElem.getAttribute(ReportSpecification20._refQuery);
            if (queryName.equals(name)) {
                return refQueryElem;
            }
            layoutElement = XmlUtils.getParentElement(refQueryElem);
        }
        return null;
    }

    public Element findRefQueryElementForDataItem(Element layoutElement, String refDataItem) {
        Element refQueryElem = BeringQueryFinder.findRefQueryElement(layoutElement);
        if (refQueryElem == null) {
            return null;
        }
        String queryName = refQueryElem.getAttribute(ReportSpecification20._refQuery);
        Document reportSpec = layoutElement.getOwnerDocument();
        Element query = BeringQueryFinder.findQueryElement(reportSpec, queryName);
        if (query == null) {
            return null;
        }
        if (BeringQueryFinder.queryContainsDataItem(query, refDataItem)) {
            return refQueryElem;
        }
        Node parent = refQueryElem.getParentNode();
        if (!(parent instanceof Element)) {
            return null;
        }
        Element parentElement = (Element)parent;
        return this.findRefQueryElementForDataItem(parentElement, refDataItem);
    }

    public static String findQueryName(Element layoutElement) {
        Element refQueryElement = BeringQueryFinder.findRefQueryElement(layoutElement);
        if (refQueryElement == null) {
            return null;
        }
        String refQuery = refQueryElement.getAttribute(ReportSpecification20._refQuery);
        return refQuery;
    }

    public static boolean queryContainsDataItem(Element query, NameExpression refDataItem) {
        String queryName;
        String refQuery = refDataItem.getQueryName();
        if (refQuery != null && !(queryName = query.getAttribute(ReportSpecification20._name)).equals(refQuery)) {
            return false;
        }
        String dataItem = refDataItem.getDataItem();
        return BeringQueryFinder.queryContainsDataItem(query, dataItem);
    }

    public static boolean queryContainsDataItem(Element query, String dataItem) {
        Element selection = XmlUtils.getFirstChildElementByName(query, ReportSpecification20._selection);
        Element dataItemElement = XmlUtils.getFirstChildElementByNameWithAttributeValue(selection, ReportSpecification20._dataItem, ReportSpecification20._name, dataItem);
        return dataItemElement != null;
    }

    @Override
    public String findQueryName(Element elem, String dataItem) {
        Element refQueryElem = this.findRefQueryElementForDataItem(elem, dataItem);
        if (refQueryElem == null) {
            return null;
        }
        return refQueryElem.getAttribute(ReportSpecification20._refQuery);
    }

    public static Element findQueryElement(Document v5Spec, String queryName) {
        Element report = XmlUtils.getFirstChildElementByName(v5Spec, ReportSpecification20._report);
        Element queries = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._queries);
        if (queries == null) {
            return null;
        }
        Element query = XmlUtils.getFirstChildElementByNameWithAttributeValue(queries, ReportSpecification20._query, ReportSpecification20._name, queryName);
        return query;
    }

    public static boolean queryContainsDataItem(Element query, RefDataItem refDataItem) {
        String queryName;
        String refQuery = refDataItem.getQueryName();
        if (refQuery != null && !(queryName = query.getAttribute(ReportSpecification20._name)).equals(refQuery)) {
            return false;
        }
        String dataItem = refDataItem.getDataItem();
        Element selection = XmlUtils.getFirstChildElementByName(query, ReportSpecification20._selection);
        Element dataItemElement = XmlUtils.getFirstChildElementByNameWithAttributeValue(selection, ReportSpecification20._dataItem, ReportSpecification20._name, dataItem);
        return dataItemElement != null;
    }

    public boolean isQueryInScope(String queryName, Element context) {
        while (context != null) {
            String refQuery;
            if (context.hasAttribute(ReportSpecification20._refQuery) && queryName.equals(refQuery = context.getAttribute(ReportSpecification20._refQuery))) {
                return true;
            }
            Node parent = context.getParentNode();
            if (!(parent instanceof Element)) {
                context = null;
                continue;
            }
            Element parentElement = (Element)parent;
            context = BeringQueryFinder.findRefQueryElement(parentElement);
        }
        return false;
    }

    public String findUniqueQueryWithDataItem(Document v5, String refDataItem) {
        Element report = XmlUtils.getFirstChildElementByName(v5, ReportSpecification20._report);
        Element queries = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._queries);
        if (queries == null) {
            return null;
        }
        String result = null;
        for (Node child = queries.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element childElement;
            if (!(child instanceof Element) || !XmlUtils.getName(childElement = (Element)child).equals(ReportSpecification20._query) || !BeringQueryFinder.queryContainsDataItem(childElement, refDataItem)) continue;
            if (result == null) {
                result = childElement.getAttribute(ReportSpecification20._name);
                continue;
            }
            return null;
        }
        return result;
    }

    public static NodeList findChildQueries(Element elem) {
        NodeListListImpl result = new NodeListListImpl();
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            BeringQueryFinder.findSelfOrChildQueries(childElement, result);
        }
        return result;
    }

    private static void findSelfOrChildQueries(Element elem, NodeListListImpl result) {
        if (elem.hasAttribute(ReportSpecification20._refQuery)) {
            result.add(elem);
        } else {
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof Element)) continue;
                Element childElement = (Element)child;
                BeringQueryFinder.findSelfOrChildQueries(childElement, result);
            }
        }
    }

    public static Set<String> findReferencedOriginalQueryNames(Element elem) {
        HashSet<String> result = new HashSet<String>();
        BeringQueryFinder.findReferencedOriginalQueryNames(elem, result);
        return result;
    }

    private static void findReferencedOriginalQueryNames(Element elem, Set<String> result) {
        if (elem.hasAttribute("originalRefQuery")) {
            result.add(elem.getAttribute("originalRefQuery"));
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            BeringQueryFinder.findReferencedOriginalQueryNames(childElement, result);
        }
    }
}

