/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlCommentOutTool;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessageTemplate;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlCommentOutToolImpl
implements XmlCommentOutTool {
    private final Messages translatedMessages;
    private Set<XmlCommentOutTool.CommentOutListener> listeners = new HashSet<XmlCommentOutTool.CommentOutListener>();

    public XmlCommentOutToolImpl(Messages translatedMessages) {
        this.translatedMessages = translatedMessages;
    }

    @Override
    public void addListener(XmlCommentOutTool.CommentOutListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(XmlCommentOutTool.CommentOutListener listener) {
        this.listeners.remove(listener);
    }

    private void notify(Node node) throws XmlException {
        for (XmlCommentOutTool.CommentOutListener listener : this.listeners) {
            listener.commentedOutNotification(node);
        }
    }

    private void doCommentOut(Node node, String msg) {
        try {
            StringWriter removedNodeWriter = new StringWriter();
            if (msg != null) {
                removedNodeWriter.write(msg);
            }
            XmlUtils.writeDocument(removedNodeWriter, node);
            removedNodeWriter.close();
            String removedNodeText = removedNodeWriter.toString();
            XmlUtils.insertComment(node, removedNodeText);
        }
        catch (Exception removedNodeWriter) {
            // empty catch block
        }
        if (node instanceof Attr) {
            Attr attr = (Attr)node;
            Element owner = attr.getOwnerElement();
            owner.removeAttributeNode(attr);
        } else {
            Node parent = node.getParentNode();
            parent.removeChild(node);
        }
    }

    @Override
    public void commentOutNode(Node node) throws XmlException {
        this.commentOutNode(node, (String)null);
    }

    @Override
    public void commentOutNode(Node node, String message) throws XmlException {
        this.notify(node);
        this.doCommentOut(node, message);
    }

    @Override
    public void commentOutNode(Node node, MessageTemplate message) throws XmlException {
        String text = this.translatedMessages.getString(message);
        this.commentOutNode(node, text);
    }
}

