/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.ElementModel;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.LookaheadResult;
import com.cognos.rspecupgrade.internal.xml.schema.MultipleModel;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.SingleModel;
import com.cognos.rspecupgrade.internal.xml.schema.StructureModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AllModel
implements SingleModel {
    private LinkedList<StructureModel> children = new LinkedList();

    AllModel(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        String schemaType = schemaElement.getLocalName();
        if (!schemaType.equals("all")) {
            throw new InternalErrorException("Internal error. Unexpected type: " + schemaType);
        }
        Node schemaChild = schemaElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            StructureModel modelNode;
            Element childElement = (Element)schemaChild;
            schemaType = childElement.getLocalName();
            if (!schemaType.equals("annotation") && (modelNode = model.getStructureModelNode(childElement)) != null) {
                this.children.addLast(modelNode);
            }
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
    }

    @Override
    public LookaheadResult lookahead(Node docNode) throws SchemaException {
        if ((docNode = XmlUtils.skipBlankTextAndComments(docNode)) != null && !(docNode instanceof Element)) {
            return LookaheadResult.No;
        }
        Element elem = (Element)docNode;
        LookaheadResult result = LookaheadResult.NoTokensConsumed;
        for (StructureModel modelNode : this.children) {
            LookaheadResult lookaheadResult = modelNode.lookahead(elem);
            if (lookaheadResult == LookaheadResult.Yes) {
                return LookaheadResult.Yes;
            }
            if (lookaheadResult != LookaheadResult.No) continue;
            result = LookaheadResult.No;
        }
        return result;
    }

    @Override
    public Node consume(Node parentNode, Node docNode, DocumentFixer fixer) throws SchemaException {
        int oldUsage;
        if (this.lookahead(docNode) != LookaheadResult.Yes) {
            throw new InternalErrorException("Internal error. Consuming when there is no match. Create should be called first to make the lookahead pass.");
        }
        HashMap<StructureModel, Integer> usage = new HashMap<StructureModel, Integer>(this.children.size());
        for (StructureModel child : this.children) {
            usage.put(child, new Integer(0));
        }
        docNode = XmlUtils.skipBlankTextAndComments(docNode);
        Node oldDocNode = null;
        block1: while (docNode != null && oldDocNode != docNode) {
            oldDocNode = docNode;
            for (StructureModel child : this.children) {
                if (child.lookahead(docNode) != LookaheadResult.Yes) continue;
                oldUsage = (Integer)usage.get(child);
                if (oldUsage > 0) continue block1;
                usage.put(child, new Integer(1));
                docNode = child.consume(parentNode, docNode, fixer);
                docNode = XmlUtils.skipBlankTextAndComments(docNode);
                continue block1;
            }
        }
        for (StructureModel child : this.children) {
            oldUsage = (Integer)usage.get(child);
            int minOccurs = child.getMinOccurs();
            if (minOccurs <= 0 || oldUsage != 0) continue;
            Node newDocNode = child.create(parentNode, docNode, fixer);
            if ((newDocNode = child.consume(parentNode, newDocNode, fixer)) == docNode) continue;
            throw new InternalErrorException("Internal error. More nodes consumed then created.");
        }
        return docNode;
    }

    @Override
    public Node create(Node parentNode, Node nextSibling, DocumentFixer fixer) throws SchemaException {
        StructureModel modelToCreate = null;
        Iterator iter = this.children.iterator();
        while (iter.hasNext() && modelToCreate == null) {
            StructureModel modelNode = (StructureModel)iter.next();
            if (modelNode.getMinOccurs() <= 0) continue;
            modelToCreate = modelNode;
        }
        if (modelToCreate == null) {
            throw new InternalErrorException("Internal error. No need to create nodes, everything is optional.");
        }
        Node newNode = modelToCreate.create(parentNode, nextSibling, fixer);
        return newNode;
    }

    @Override
    public int getMinOccurs() {
        return 1;
    }

    @Override
    public boolean definesElement(String elementName) throws SchemaException {
        for (Object e : this.children) {
            MultipleModel mult;
            ElementModel elem;
            if (!(e instanceof ElementModel ? (elem = (ElementModel)e).definesElement(elementName) : (mult = (MultipleModel)e).definesElement(elementName))) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContentModel getModel(Node childNode) throws SchemaException {
        if (childNode instanceof Element) {
            return this.getModel((Element)childNode);
        }
        throw new InternalError("All nodes can only have elements as children.");
    }

    private ElementModel getModel(Element element) throws SchemaException {
        for (StructureModel childModel : this.children) {
            ElementModel elemModel = (ElementModel)childModel.getModel(element);
            if (elemModel == null) continue;
            return elemModel;
        }
        return null;
    }
}

