/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.AttributeGroupModel;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class AttributeCollection
implements Cloneable,
Iterable<AttributeModel> {
    private LinkedList<AttributeModel> attributes = new LinkedList();

    public AttributeCollection() {
    }

    public AttributeCollection(AttributeCollection[] attributeCollections) {
        for (AttributeCollection collection : attributeCollections) {
            this.attributes.addAll(collection.attributes);
        }
    }

    void add(AttributeModel model) {
        this.attributes.addLast(model);
    }

    void add(AttributeGroupModel groupModel) {
        Iterator<AttributeModel> attributes = groupModel.attributeModels();
        while (attributes.hasNext()) {
            AttributeModel attr = attributes.next();
            this.attributes.addLast(attr);
        }
    }

    void add(AttributeCollection anAttributesCollection) {
        this.attributes.addAll(anAttributesCollection.attributes);
    }

    private void checkDefinedAttributes(Element docNode, DocumentFixer fixer) throws SchemaException {
        for (AttributeModel modelNode : this.attributes) {
            modelNode.validateAndFix(docNode, fixer);
        }
    }

    private boolean isSpecialAttribute(String name) {
        if (name.equals("xmlns")) {
            return true;
        }
        if (name.startsWith("xmlns:")) {
            return true;
        }
        return name.startsWith("xsi:");
    }

    private void checkUndefinedAttributes(Element docNode, DocumentFixer fixer) throws SchemaException {
        String name;
        HashMap<String, Attr> undefinedAttributes = new HashMap<String, Attr>();
        NamedNodeMap docAttributes = docNode.getAttributes();
        int nbAttributes = docAttributes.getLength();
        for (int i = 0; i < nbAttributes; ++i) {
            Attr attr = (Attr)docAttributes.item(i);
            name = attr.getName();
            if (this.isSpecialAttribute(name)) continue;
            undefinedAttributes.put(name, attr);
        }
        for (AttributeModel modelNode : this.attributes) {
            name = modelNode.getName();
            undefinedAttributes.remove(name);
        }
        if (!undefinedAttributes.isEmpty()) {
            Attr anAttr = (Attr)undefinedAttributes.values().iterator().next();
            fixer.removeAttribute(anAttr);
        }
    }

    void validateAndFix(Element docNode, DocumentFixer fixer) throws SchemaException {
        this.checkDefinedAttributes(docNode, fixer);
        this.checkUndefinedAttributes(docNode, fixer);
    }

    boolean definesAttribute(String attributeName) {
        AttributeModel result = this.getAttributeModel(attributeName);
        return result != null;
    }

    AttributeModel getAttributeModel(String attributeName) {
        for (AttributeModel modelNode : this.attributes) {
            AttributeModel result = modelNode.getAttributeModel(attributeName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Iterator<AttributeModel> attributeModels() {
        return this.attributes.iterator();
    }

    public AttributeModel getModel(Attr attr) throws SchemaException {
        String attributeName = attr.getName();
        return this.getAttributeModel(attributeName);
    }

    protected AttributeCollection clone() throws CloneNotSupportedException {
        AttributeCollection theClone = (AttributeCollection)super.clone();
        theClone.attributes = (LinkedList)this.attributes.clone();
        return theClone;
    }

    @Override
    public Iterator<AttributeModel> iterator() {
        return this.attributes.iterator();
    }
}

