/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeCollection;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeGroupModel;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeImplementation;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeStructuredImpl;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.NotImplementedException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.StructureModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ComplexTypeEmptyImpl
implements ComplexTypeImplementation {
    private AttributeCollection attributes = new AttributeCollection();

    ComplexTypeEmptyImpl() {
    }

    @Override
    public void addAttribute(AttributeModel attr) throws SchemaException {
        this.attributes.add(attr);
    }

    @Override
    public void addAttributeGroup(AttributeGroupModel attr) throws SchemaException {
        this.attributes.add(attr);
    }

    @Override
    public void checkAttributes(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.attributes.validateAndFix(docElement, fixer);
    }

    @Override
    public void checkChildren(Element docElement, DocumentFixer fixer) throws SchemaException {
        Node child = docElement.getFirstChild();
        if ((child = XmlUtils.skipBlankTextAndComments(child)) != null) {
            fixer.remove(child);
        }
    }

    @Override
    public boolean definesAttribute(String attributeName) throws SchemaException {
        return this.attributes.definesAttribute(attributeName);
    }

    @Override
    public boolean definesElement(String elementName) throws SchemaException {
        return false;
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        if (!(child instanceof Attr)) {
            return null;
        }
        return this.attributes.getModel((Attr)child);
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws SchemaException {
        throw new InternalErrorException("Semantic value is not defined for types with no content");
    }

    @Override
    public void load(Element complexTypeElement, SchemaModelImpl model) throws SchemaException {
        Node schemaChild = complexTypeElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            Object attr;
            Element childElement = (Element)schemaChild;
            String schemaType = childElement.getLocalName();
            if (schemaType.equals("simpleContent")) {
                throw new InternalError("content not expected");
            }
            if (schemaType.equals("complexContent")) {
                throw new InternalError("content not expected");
            }
            if (schemaType.equals("attribute")) {
                attr = model.getAttributeModel(childElement);
                this.attributes.add((AttributeModel)attr);
            } else if (schemaType.equals("attributeGroup")) {
                attr = model.getAttributeGroupModel(childElement);
                this.attributes.add((AttributeGroupModel)attr);
            } else {
                if (schemaType.equals("group")) {
                    throw new InternalErrorException(schemaType + " should have triggered use of ComplexTypeStructuredImpl");
                }
                if (schemaType.equals("all")) {
                    throw new InternalErrorException(schemaType + " should have triggered use of ComplexTypeStructuredImpl");
                }
                if (schemaType.equals("sequence")) {
                    throw new InternalErrorException(schemaType + " should have triggered use of ComplexTypeStructuredImpl");
                }
                if (schemaType.equals("choice")) {
                    throw new InternalErrorException(schemaType + " should have triggered use of ComplexTypeStructuredImpl");
                }
                if (schemaType.equals("anyAttribute")) {
                    throw new NotImplementedException(schemaType);
                }
                throw new InvalidSchemaException(schemaType + " was not expected.");
            }
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
    }

    @Override
    public ComplexTypeModel extend(AttributeCollection extendedAttributes, StructureModel extendedStructure) throws SchemaException {
        ComplexTypeImplementation newImplementation;
        if (extendedStructure != null) {
            AttributeCollection mergedAttributes = new AttributeCollection(new AttributeCollection[]{this.attributes, extendedAttributes});
            newImplementation = new ComplexTypeStructuredImpl(mergedAttributes, extendedStructure);
        } else {
            ComplexTypeEmptyImpl newEmptyType;
            try {
                newEmptyType = this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalErrorException(e);
            }
            newEmptyType.attributes.add(extendedAttributes);
            newImplementation = newEmptyType;
        }
        return new ComplexTypeModel(newImplementation);
    }

    @Override
    public ComplexTypeEmptyImpl clone() throws CloneNotSupportedException {
        return (ComplexTypeEmptyImpl)super.clone();
    }
}

