/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeCollection;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeGroupModel;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeImplementation;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.ElementModel;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.LookaheadResult;
import com.cognos.rspecupgrade.internal.xml.schema.NotImplementedException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.StructureModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ComplexTypeStructuredImpl
implements ComplexTypeImplementation,
Cloneable {
    private AttributeCollection attributes;
    private StructureModel complexTypeDefinition;

    ComplexTypeStructuredImpl() {
        this.attributes = new AttributeCollection();
        this.complexTypeDefinition = null;
    }

    ComplexTypeStructuredImpl(AttributeCollection theAttributes, StructureModel structure) {
        this.attributes = theAttributes;
        this.complexTypeDefinition = structure;
    }

    @Override
    public void checkAttributes(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.attributes.validateAndFix(docElement, fixer);
    }

    @Override
    public void checkChildren(Element docElement, DocumentFixer fixer) throws SchemaException {
        Node lastChild;
        Node docChild = docElement.getFirstChild();
        if (this.complexTypeDefinition == null) {
            lastChild = docChild;
        } else {
            LookaheadResult lookaheadResult = this.complexTypeDefinition.lookahead(docChild);
            if (lookaheadResult == LookaheadResult.NoTokensConsumed) {
                lastChild = docChild;
            } else {
                if (lookaheadResult == LookaheadResult.No) {
                    docChild = this.complexTypeDefinition.create(docElement, docChild, fixer);
                }
                lastChild = this.complexTypeDefinition.consume(docElement, docChild, fixer);
            }
        }
        lastChild = XmlUtils.skipBlankTextAndComments(lastChild);
        while (lastChild != null) {
            lastChild = fixer.remove(lastChild);
            lastChild = XmlUtils.skipBlankTextAndComments(lastChild);
        }
    }

    @Override
    public void load(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        String mixed;
        String schemaType = schemaElement.getLocalName();
        if (!schemaType.equals("complexType")) {
            throw new InternalErrorException("Internal error. Unexpected type: " + schemaType);
        }
        if (schemaElement.hasAttribute("abstract")) {
            throw new NotImplementedException("Not implemented.  Attribute abstract.");
        }
        if (schemaElement.hasAttribute("block")) {
            throw new NotImplementedException("Not implemented.  Attribute block.");
        }
        if (schemaElement.hasAttribute("final")) {
            throw new NotImplementedException("Not implemented. Attribute final.");
        }
        if (schemaElement.hasAttribute("mixed") && (mixed = schemaElement.getAttribute("mixed")).equals("true")) {
            throw new NotImplementedException("Not implemented.  Attribute mixed=\"true\".");
        }
        Node schemaChild = schemaElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            Element childElement = (Element)schemaChild;
            schemaType = childElement.getLocalName();
            if (!schemaType.equals("annotation")) {
                Object attr;
                if (schemaType.equals("attribute")) {
                    attr = model.getAttributeModel(childElement);
                    this.attributes.add((AttributeModel)attr);
                } else if (schemaType.equals("attributeGroup")) {
                    attr = model.getAttributeGroupModel(childElement);
                    this.attributes.add((AttributeGroupModel)attr);
                } else {
                    if (schemaType.equals("simpleContent")) {
                        throw new InternalErrorException("Internal error.  Only complexTypes with structure content should be loaded with this class.");
                    }
                    if (schemaType.equals("complexContent")) {
                        throw new InternalErrorException("Internal error. Only complexTypes with structure content should be loaded with this class.");
                    }
                    if (this.complexTypeDefinition != null) {
                        throw new InvalidSchemaException("Invalid schema. Only one child permitted. Verify that schema is valid with XML Schema 1.1 Part 1: Structures, W3C Working Draft 31 August 2006 (http://www.w3.org/TR/xmlschema11-1/)");
                    }
                    this.complexTypeDefinition = model.getStructureModelNode(childElement);
                }
            }
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
    }

    @Override
    public boolean definesAttribute(String attributeName) throws SchemaException {
        return this.attributes.definesAttribute(attributeName);
    }

    @Override
    public boolean definesElement(String elementName) throws SchemaException {
        if (this.complexTypeDefinition == null) {
            return false;
        }
        return this.complexTypeDefinition.definesElement(elementName);
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        if (child instanceof Element) {
            return this.getModel((Element)child);
        }
        if (child instanceof Attr) {
            return this.getModel((Attr)child);
        }
        throw new NotImplementedException("Type is not supported: " + child.getClass().getName());
    }

    private AttributeModel getModel(Attr attr) throws SchemaException {
        return this.attributes.getModel(attr);
    }

    private ElementModel getModel(Element elem) throws SchemaException {
        return (ElementModel)this.complexTypeDefinition.getModel(elem);
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws SchemaException {
        throw new InvalidSchemaException("Structures do not have a semantic value");
    }

    @Override
    public void addAttribute(AttributeModel attr) {
        this.attributes.add(attr);
    }

    @Override
    public void addAttributeGroup(AttributeGroupModel attr) {
        this.attributes.add(attr);
    }

    @Override
    public ComplexTypeModel extend(AttributeCollection extendedAttributes, StructureModel extendedStructure) throws SchemaException {
        ComplexTypeStructuredImpl newImplementation;
        if (extendedStructure != null) {
            throw new NotImplementedException();
        }
        try {
            newImplementation = this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalErrorException(e);
        }
        newImplementation.attributes.add(extendedAttributes);
        return new ComplexTypeModel(newImplementation);
    }

    @Override
    public ComplexTypeStructuredImpl clone() throws CloneNotSupportedException {
        ComplexTypeStructuredImpl aClone = (ComplexTypeStructuredImpl)super.clone();
        aClone.attributes = this.attributes.clone();
        aClone.complexTypeDefinition = this.complexTypeDefinition;
        return aClone;
    }
}

