/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.RangeFramework;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.TypeOperations;
import java.math.BigDecimal;

public class DecimalRange
extends RangeFramework<BigDecimal> {
    private static BigDecimal bigONE = new BigDecimal("1");
    private static BigDecimal bigTWO = new BigDecimal("2");
    private static BigDecimal bigMINUSONE = new BigDecimal("-1");

    public DecimalRange() {
        super(new BigDecimalOperations());
    }

    public DecimalRange(String minExclusive, String minInclusive, String maxInclusive, String maxExclusive) throws SchemaException {
        super(new BigDecimalOperations(), minExclusive, minInclusive, maxInclusive, maxExclusive);
    }

    public static class BigDecimalOperations
    implements TypeOperations<BigDecimal> {
        @Override
        public BigDecimal decrease(BigDecimal obj) throws SchemaException {
            return obj.add(bigMINUSONE);
        }

        @Override
        public BigDecimal increase(BigDecimal obj) throws SchemaException {
            return obj.add(bigONE);
        }

        @Override
        public BigDecimal exclusiveBoundary(BigDecimal lowerBound, BigDecimal upperBound) throws SchemaException {
            BigDecimal lower = lowerBound;
            BigDecimal upper = upperBound;
            BigDecimal offset = upper.subtract(lower);
            int quotientScale = Math.max(lower.scale(), upper.scale()) + 1;
            BigDecimal midPoint = lower.add(offset.divide(bigTWO, quotientScale, 0));
            if (midPoint.compareTo(upper) >= 0) {
                throw new InvalidSchemaException("Failed to find a value between " + lower.toString() + " and " + upper.toString() + ".");
            }
            return midPoint;
        }

        @Override
        public BigDecimal newObject(String lexicalValue) throws SchemaException {
            try {
                return new BigDecimal(lexicalValue);
            }
            catch (NumberFormatException e) {
                throw new SchemaException(e);
            }
        }

        @Override
        public String toString(BigDecimal object) {
            return object.toString();
        }
    }
}

