/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlCommentOutTool;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.internal.xml.schema.AbortSchemaValidation;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.RestartSchemaValidation;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DefaultDocumentFixer
implements DocumentFixer {
    private SchemaModel schemaModel;
    private XmlCommentOutTool commentOutTool;

    DefaultDocumentFixer(XmlCommentOutTool commentTool, SchemaModel schemaModel) {
        this.commentOutTool = commentTool;
        this.schemaModel = schemaModel;
    }

    @Override
    public void invalidValue(Attr attr, String validValue) throws AbortSchemaValidation {
        attr.setValue(validValue);
    }

    @Override
    public void removeAttribute(Attr attr) throws AbortSchemaValidation {
        Element parent = attr.getOwnerElement();
        String attributeName = attr.getName();
        parent.removeAttribute(attributeName);
    }

    @Override
    public Attr createAttribute(Element element, String attributeName, String validValue) throws AbortSchemaValidation {
        Document doc = element.getOwnerDocument();
        Attr newAttribute = doc.createAttribute(attributeName);
        newAttribute.setValue(validValue);
        element.setAttributeNode(newAttribute);
        return newAttribute;
    }

    @Override
    public Node remove(Node node) throws AbortSchemaValidation {
        Node sibling = node.getNextSibling();
        Node parent = node.getParentNode();
        parent.removeChild(node);
        return sibling;
    }

    @Override
    public void createRoot(Document doc) throws AbortSchemaValidation {
        Element newElement = doc.createElementNS(this.schemaModel.getTargetNamespace(), "report");
        doc.insertBefore(newElement, null);
    }

    @Override
    public Element createElement(Node parent, Node insertBefore, String elementName) throws AbortSchemaValidation {
        Document doc = XmlUtils.getOwnerDoc(parent);
        String namespace = parent.getNamespaceURI();
        Element newElement = doc.createElementNS(namespace, elementName);
        parent.insertBefore(newElement, insertBefore);
        return newElement;
    }

    @Override
    public Text createText(Node parent, Node insertBefore, String textContent) throws AbortSchemaValidation {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Text text = doc.createTextNode(textContent);
        parent.insertBefore(text, insertBefore);
        return text;
    }

    @Override
    public void invalidValue(Text text, String validValue) throws AbortSchemaValidation {
        text.setData(validValue);
    }

    @Override
    public void keyNotUnique(Element element, String keyId, Vector<Object> keySquence) throws AbortSchemaValidation {
        Document doc = element.getOwnerDocument();
        Element root = doc.getDocumentElement();
        try {
            this.commentOutTool.commentOutNode(root);
        }
        catch (XmlException e) {
            throw new AbortSchemaValidation(e);
        }
        throw new RestartSchemaValidation();
    }

    @Override
    public void keyFieldMissing(Element element, String keyName, String fieldId) throws AbortSchemaValidation {
        Document doc = element.getOwnerDocument();
        Element root = doc.getDocumentElement();
        try {
            this.commentOutTool.commentOutNode(root);
        }
        catch (XmlException e) {
            throw new AbortSchemaValidation(e);
        }
        throw new RestartSchemaValidation();
    }

    @Override
    public void keyrefMissing(Element element, String keyrefName, Vector<Object> keySequence) throws AbortSchemaValidation {
        Document doc = element.getOwnerDocument();
        Element root = doc.getDocumentElement();
        try {
            this.commentOutTool.commentOutNode(root);
        }
        catch (XmlException e) {
            throw new AbortSchemaValidation(e);
        }
        throw new RestartSchemaValidation();
    }

    @Override
    public void keyrefMissingField(Element element, String keyrefName, String missingField) throws AbortSchemaValidation {
        Document doc = element.getOwnerDocument();
        Element root = doc.getDocumentElement();
        try {
            this.commentOutTool.commentOutNode(root);
        }
        catch (XmlException e) {
            throw new AbortSchemaValidation(e);
        }
        throw new RestartSchemaValidation();
    }

    @Override
    public void notUnique(Node node, String constraintName) throws AbortSchemaValidation {
        try {
            this.commentOutTool.commentOutNode(node);
        }
        catch (XmlException e) {
            throw new AbortSchemaValidation(e);
        }
        throw new RestartSchemaValidation();
    }
}

