/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.Field;
import com.cognos.rspecupgrade.internal.xml.schema.Fields;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.Loadable;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.selector.ParseException;
import com.cognos.rspecupgrade.internal.xml.schema.selector.SelectorPath;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.Selector;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyModel
implements Loadable {
    private String id;
    private String name;
    private Selector selectorXpath;
    private Fields fields = new Fields();

    @Override
    public void load(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        try {
            String localName = schemaElement.getLocalName();
            if (!localName.equals("key")) {
                throw new InternalErrorException("Wrong element, expected key and got " + localName);
            }
            if (schemaElement.hasAttribute("id")) {
                this.id = schemaElement.getAttribute("id");
            }
            this.name = schemaElement.getAttribute("name");
            Element selector = XmlUtils.getFirstChildElementByName(schemaElement, "selector");
            if (selector == null) {
                throw new InvalidSchemaException("selector not found.");
            }
            String xpath = selector.getAttribute("xpath");
            this.selectorXpath = SelectorPath.compile(xpath, selector);
            NodeList fieldList = XmlUtils.getChildElementsByName(schemaElement, "field");
            int nbFields = fieldList.getLength();
            for (int i = 0; i < nbFields; ++i) {
                Element fieldElement = (Element)fieldList.item(i);
                Field field = new Field(fieldElement, model);
                this.fields.add(field);
            }
        }
        catch (ParseException e) {
            throw new SchemaException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    Set<Vector<Object>> getValues(Element element, DocumentFixer fixer) throws SchemaException {
        NodeList targetNodeSet = this.selectorXpath.evaluate(element);
        HashSet<Vector<Object>> values = new HashSet<Vector<Object>>();
        int nbNodes = targetNodeSet.getLength();
        for (int nodeNb = 0; nodeNb < nbNodes; ++nodeNb) {
            Element targetElement = (Element)targetNodeSet.item(nodeNb);
            if (!this.fields.isDefined(targetElement)) continue;
            Vector<Object> keySequence = this.fields.getSemanticValue(targetElement);
            if (values.contains(keySequence)) {
                fixer.keyNotUnique(element, this.id, keySequence);
                return this.getValues(element, fixer);
            }
            values.add(keySequence);
        }
        return values;
    }
}

