/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.Named;
import com.cognos.rspecupgrade.internal.xml.schema.NamedModelMap;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaNamespaceContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NamedModelFactory {
    ModelFactory modelFactory;
    NamedModelMap namedModelMap;
    Map<NamespaceQualifiedName, Element> modelDefinitions;

    NamedModelFactory(NamedModelMap modelMap, ModelFactory factory) {
        this.namedModelMap = modelMap;
        this.modelFactory = factory;
    }

    Object getNamedObject(NamespaceQualifiedName name) throws SchemaException {
        if (this.namedModelMap.containsKey(name)) {
            return this.namedModelMap.get(name);
        }
        Element modelDefinition = this.modelDefinitions.get(name);
        if (modelDefinition == null) {
            throw new InvalidSchemaException("Node definition for model: " + name);
        }
        this.modelDefinitions.remove(name);
        Named object = this.modelFactory.create(modelDefinition, this);
        this.namedModelMap.put(name, object);
        return object;
    }

    private void loadNamedDefinitionElements(Document schemaDocument, String typeName, String targetNamespace) throws XPathExpressionException {
        String path = "/xs:schema/" + typeName + "[@name]";
        NodeList schemaNodes = XmlUtils.selectNodeList(schemaDocument, path, SchemaNamespaceContext.instance);
        int nbNodes = schemaNodes.getLength();
        this.modelDefinitions = new HashMap<NamespaceQualifiedName, Element>(nbNodes);
        for (int i = 0; i < nbNodes; ++i) {
            Element schemaElement = (Element)schemaNodes.item(i);
            String localName = schemaElement.getAttribute("name");
            NamespaceQualifiedName name = new NamespaceQualifiedName(targetNamespace, localName);
            this.modelDefinitions.put(name, schemaElement);
        }
    }

    private void loadNamedModels() throws SchemaException {
        while (!this.modelDefinitions.isEmpty()) {
            Iterator<NamespaceQualifiedName> nameIter = this.modelDefinitions.keySet().iterator();
            NamespaceQualifiedName name = nameIter.next();
            this.getNamedObject(name);
        }
    }

    void createNonRecursiveDefinitions(Document schemaDocument, String typeName, String targetNamespace) throws SchemaException {
        try {
            this.loadNamedDefinitionElements(schemaDocument, typeName, targetNamespace);
            this.loadNamedModels();
        }
        catch (XPathExpressionException ex) {
            throw new InternalErrorException(ex);
        }
    }

    static interface ModelFactory {
        public Named create(Element var1, NamedModelFactory var2) throws SchemaException;
    }
}

