/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.MessageGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.NamedModelFactory;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.NotImplementedException;
import com.cognos.rspecupgrade.internal.xml.schema.Range;
import com.cognos.rspecupgrade.internal.xml.schema.Restriction;
import com.cognos.rspecupgrade.internal.xml.schema.RestrictionEnumeration;
import com.cognos.rspecupgrade.internal.xml.schema.RestrictionPattern;
import com.cognos.rspecupgrade.internal.xml.schema.RestrictionRange;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import com.cognos.rspecupgrade.internal.xml.xpath.XPathGenerator;
import java.util.LinkedList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Restrictions {
    LinkedList<Restriction> restrictions = new LinkedList();
    SimpleType baseImplementation;
    private Range boundaries;

    Restrictions(SimpleType baseType) {
        this.baseImplementation = baseType;
    }

    private String getValueAttribute(Element parent, String childName) {
        Element child = XmlUtils.getFirstChildElementByName(parent, childName);
        if (child == null) {
            return null;
        }
        return child.getAttribute("value");
    }

    private void loadRange(Element restrictionElement) throws SchemaException {
        String minInclusive = this.getValueAttribute(restrictionElement, "minInclusive");
        String minExclusive = this.getValueAttribute(restrictionElement, "minExclusive");
        String maxInclusive = this.getValueAttribute(restrictionElement, "maxInclusive");
        String maxExclusive = this.getValueAttribute(restrictionElement, "maxExclusive");
        if (minInclusive != null || minExclusive != null || maxInclusive != null || maxExclusive != null) {
            this.boundaries = this.baseImplementation.newRangeInstance(minExclusive, minInclusive, maxInclusive, maxExclusive);
            this.restrictions.addLast(new RestrictionRange(this.boundaries));
        }
    }

    private void assertElementType(String expectedName, Element element) throws InternalErrorException {
        String actualName = XmlUtils.getName(element);
        if (!expectedName.equals(actualName)) {
            throw new InternalErrorException("Wrong type of element expected " + expectedName + " but got " + actualName);
        }
    }

    private void loadEnumeration(final Element enumerationElement, RestrictionEnumeration enumerationRestrictions) throws InvalidSchemaException, InternalErrorException {
        this.assertElementType("enumeration", enumerationElement);
        MessageGenerator errorMessage = new MessageGenerator(){

            @Override
            public String getMessage() {
                String path = XPathGenerator.getXPath(enumerationElement);
                return "Error loading enumeration at " + path + "\n";
            }
        };
        if (!enumerationElement.hasAttribute("value")) {
            throw new InvalidSchemaException("value attribute is missing from enumeration." + errorMessage.getMessage());
        }
        Attr valueAttribute = enumerationElement.getAttributeNode("value");
        String enumerationValue = valueAttribute.getValue();
        enumerationRestrictions.addEnumeratedValue(enumerationValue, errorMessage);
    }

    protected void loadEnumerations(Element restrictionElement) throws SchemaException {
        this.assertElementType("restriction", restrictionElement);
        NodeList enumerationElements = XmlUtils.getChildElementsByName(restrictionElement, "enumeration");
        if (enumerationElements.getLength() > 0) {
            RestrictionEnumeration enumerationRestrictions = new RestrictionEnumeration(this.baseImplementation);
            for (int i = 0; i < enumerationElements.getLength(); ++i) {
                Element enumerationElement = (Element)enumerationElements.item(i);
                this.loadEnumeration(enumerationElement, enumerationRestrictions);
            }
            this.restrictions.add(enumerationRestrictions);
        }
    }

    void loadPattern(Element patternElement) throws SchemaException {
        String patternString = patternElement.getAttribute("value");
        RestrictionPattern pattern = new RestrictionPattern(patternString);
        this.restrictions.add(pattern);
    }

    Restrictions(Element restrictionElement, NamedModelFactory simpleTypeFactory) throws SchemaException {
        String type = restrictionElement.getLocalName();
        if (!type.equals("restriction")) {
            throw new InternalErrorException("Internal error. restriction expected.");
        }
        if (!restrictionElement.hasAttribute("base")) {
            throw new InvalidSchemaException("Invalid schema. restriction must have attribute base");
        }
        String baseName = restrictionElement.getAttribute("base");
        NamespaceQualifiedName qualifiedBaseName = new NamespaceQualifiedName(baseName, restrictionElement);
        this.baseImplementation = (SimpleType)simpleTypeFactory.getNamedObject(qualifiedBaseName);
        Node childNode = restrictionElement.getFirstChild();
        childNode = XmlUtils.skipBlankTextAndComments(childNode);
        while (childNode != null) {
            Element childElement = (Element)childNode;
            type = childElement.getLocalName();
            if (!type.equals("annotation")) {
                if (type.equals("simpleType")) {
                    throw new NotImplementedException("Not implemented. simpleType");
                }
                if (!(type.equals("minExclusive") || type.equals("minInclusive") || type.equals("maxExclusive") || type.equals("maxInclusive"))) {
                    if (type.equals("totalDigits")) {
                        throw new NotImplementedException("Not implemented. totalDigits");
                    }
                    if (type.equals("fractionDigits")) {
                        throw new NotImplementedException("Not implemented. fractionDigits");
                    }
                    if (type.equals("maxScale")) {
                        throw new NotImplementedException("Not implemented. maxScale");
                    }
                    if (type.equals("minScale")) {
                        throw new NotImplementedException("Not implemented. minScale");
                    }
                    if (type.equals("length")) {
                        throw new NotImplementedException("Not implemented. length");
                    }
                    if (type.equals("minLength")) {
                        throw new NotImplementedException("Not implemented. minLength");
                    }
                    if (type.equals("maxLength")) {
                        throw new NotImplementedException("Not implmented. maxLength");
                    }
                    if (!type.equals("enumeration") && !type.equals("whiteSpace")) {
                        if (type.equals("pattern")) {
                            this.loadPattern(childElement);
                        } else {
                            throw new SchemaException("Unable to understand element: " + type);
                        }
                    }
                }
            }
            childNode = childNode.getNextSibling();
            childNode = XmlUtils.skipBlankTextAndComments(childNode);
        }
        this.loadRange(restrictionElement);
        this.loadEnumerations(restrictionElement);
    }

    String getValidValue() throws SchemaException {
        return this.getValidValue("");
    }

    public String getValidValue(String invalidValue) throws SchemaException {
        for (Restriction restriction : this.restrictions) {
            String validValue = restriction.getValidValue(invalidValue);
            if (validValue == null) continue;
            return validValue;
        }
        return this.baseImplementation.getValidValue();
    }

    public boolean isValidValue(String lexicalValue) {
        if (!this.baseImplementation.isValidValue(lexicalValue)) {
            return false;
        }
        for (Restriction restriction : this.restrictions) {
            if (restriction.isValidValue(lexicalValue)) continue;
            return false;
        }
        return true;
    }

    Object getSemanticValue(String lexicalValue) throws SchemaException {
        return this.baseImplementation.getSemanticValue(lexicalValue);
    }

    public Range newRangeInstance(String minExclusive, String minInclusive, String maxInclusive, String maxExclusive) throws SchemaException {
        if (this.boundaries != null) {
            return this.boundaries.newRangeInstance(minExclusive, minInclusive, maxInclusive, maxExclusive);
        }
        return this.baseImplementation.newRangeInstance(minExclusive, minInclusive, maxInclusive, maxExclusive);
    }

    public void assertIsValidValue(String lexicalValue, MessageGenerator message) throws InvalidSchemaException {
        for (Restriction restriction : this.restrictions) {
            restriction.assertIsValidValue(lexicalValue, message);
        }
        this.baseImplementation.assertIsValidValue(lexicalValue, message);
    }
}

