/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlCommentOutToolImpl;
import com.cognos.rspecupgrade.internal.xml.schema.AllModel;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeGroupModel;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModel;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.ChoiceModel;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexContent;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DefaultDocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.ElementModel;
import com.cognos.rspecupgrade.internal.xml.schema.GroupModel;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.KeyModel;
import com.cognos.rspecupgrade.internal.xml.schema.KeyrefModel;
import com.cognos.rspecupgrade.internal.xml.schema.Loadable;
import com.cognos.rspecupgrade.internal.xml.schema.MultipleModel;
import com.cognos.rspecupgrade.internal.xml.schema.Named;
import com.cognos.rspecupgrade.internal.xml.schema.NamedModelFactory;
import com.cognos.rspecupgrade.internal.xml.schema.NamedModelMap;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.NotImplementedException;
import com.cognos.rspecupgrade.internal.xml.schema.RestartSchemaValidation;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaNamespaceContext;
import com.cognos.rspecupgrade.internal.xml.schema.SequenceModelNode;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleTypeFactory;
import com.cognos.rspecupgrade.internal.xml.schema.SingleModel;
import com.cognos.rspecupgrade.internal.xml.schema.StructureModel;
import com.cognos.rspecupgrade.internal.xml.schema.XsBoolean;
import com.cognos.rspecupgrade.internal.xml.schema.XsDate;
import com.cognos.rspecupgrade.internal.xml.schema.XsDecimal;
import com.cognos.rspecupgrade.internal.xml.schema.XsFloat;
import com.cognos.rspecupgrade.internal.xml.schema.XsInt;
import com.cognos.rspecupgrade.internal.xml.schema.XsInteger;
import com.cognos.rspecupgrade.internal.xml.schema.XsLanguage;
import com.cognos.rspecupgrade.internal.xml.schema.XsLong;
import com.cognos.rspecupgrade.internal.xml.schema.XsNMTOKEN;
import com.cognos.rspecupgrade.internal.xml.schema.XsNMTOKENS;
import com.cognos.rspecupgrade.internal.xml.schema.XsNonNegativeInteger;
import com.cognos.rspecupgrade.internal.xml.schema.XsNonPositiveInteger;
import com.cognos.rspecupgrade.internal.xml.schema.XsPositiveInteger;
import com.cognos.rspecupgrade.internal.xml.schema.XsShort;
import com.cognos.rspecupgrade.internal.xml.schema.XsString;
import com.cognos.rspecupgrade.internal.xml.schema.XsUnsignedInt;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessagesImpl;
import java.io.File;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaModelImpl
implements SchemaModel {
    private String targetNamespace;
    private NamedModelMap namedAttributeGroups = new NamedModelMap();
    private NamedModelMap namedElements = new NamedModelMap();
    private NamedModelMap namedGroups = new NamedModelMap();
    private NamedModelMap namedSimpleTypes = new NamedModelMap();
    private NamedModelMap namedComplexTypes = new NamedModelMap();
    private NamedModelMap namedKeys = new NamedModelMap();
    private NamedModelMap namedKeyrefs = new NamedModelMap();

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.print(SchemaModelImpl.class.getName());
            System.out.println(" <schema> <out dir> <xml doc>...");
            System.out.println();
            System.out.println("Validate XML documents against a schema.");
            System.out.println("Fix broken reports so they will validate.");
            System.out.println();
            System.out.println("<schema>  Path to the schema file to use.");
            System.out.println("<out dir> Directory where valid and fixed documents.");
            System.out.println("<xml doc> Path to XML document that will be validated");
            System.out.println("  and fixed.");
            System.out.println();
            System.exit(1);
        }
        int result = 0;
        try {
            File schemaFile = new File(args[0]);
            File outDir = new File(args[1]);
            if (!outDir.isDirectory()) {
                outDir.mkdirs();
            }
            MessagesImpl messages = new MessagesImpl();
            XmlCommentOutToolImpl commentOutTool = new XmlCommentOutToolImpl(messages);
            Document schemaDoc = XmlUtils.readDocument(schemaFile);
            SchemaModelImpl model = new SchemaModelImpl(schemaDoc);
            DefaultDocumentFixer fixer = new DefaultDocumentFixer(commentOutTool, model);
            for (int i = 2; i < args.length; ++i) {
                try {
                    File inFile = new File(args[i]);
                    System.out.println("Processing " + inFile.toString());
                    File outFile = new File(outDir, inFile.getName());
                    System.out.println("outFile = " + outFile.toString());
                    Document doc = XmlUtils.readDocument(inFile);
                    model.validateAndFix(doc, fixer);
                    XmlUtils.writeDocument(outFile, (Node)doc);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                    ++result;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            ++result;
        }
        System.out.println("End of program " + result);
        System.exit(result);
    }

    public SchemaModelImpl(Document schemaDoc) throws SchemaException {
        this.loadDefinitions(schemaDoc);
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateAndFix(Document doc, DocumentFixer fixer) throws SchemaException {
        boolean tryAgain = true;
        while (tryAgain) {
            try {
                Element root = XmlUtils.getRoot(doc);
                if (root == null) {
                    fixer.createRoot(doc);
                    root = XmlUtils.getRoot(doc);
                }
                boolean rootValid = false;
                NamespaceQualifiedName rootName = null;
                while (!rootValid) {
                    rootName = new NamespaceQualifiedName(root);
                    if (this.namedElements.containsKey(rootName)) {
                        rootValid = true;
                        continue;
                    }
                    fixer.remove(root);
                    fixer.createRoot(doc);
                    root = XmlUtils.getRoot(doc);
                }
                ElementModel rootModel = this.getNamedElement(rootName);
                rootModel.consume(doc, root, fixer);
                tryAgain = false;
            }
            catch (RestartSchemaValidation e) {
                tryAgain = true;
            }
        }
    }

    ContentModel getDefiningModel(Element docNode) throws SchemaException {
        Node parentNode = docNode.getParentNode();
        if (parentNode instanceof Document) {
            Element elem = docNode;
            return this.getModel(elem);
        }
        Element parentElem = (Element)parentNode;
        ContentModel parentModel = this.getDefiningModel(parentElem);
        return parentModel.getModelForChildNode(docNode);
    }

    @Override
    public boolean isChildElementAllowed(Element parent, String childName) throws SchemaException {
        ElementModel contentModel = (ElementModel)this.getDefiningModel(parent);
        boolean allowed = contentModel.allowsChildElement(childName);
        return allowed;
    }

    @Override
    public ContentModel getDefiningModel(Attr docNode) throws SchemaException {
        Element parentNode = docNode.getOwnerElement();
        ContentModel parentModel = this.getDefiningModel(parentNode);
        return parentModel.getModelForChildNode(docNode);
    }

    public ElementModel getModel(Element childNode) throws SchemaException {
        Node parentNode = childNode.getParentNode();
        if (!(parentNode instanceof Document)) {
            throw new InternalErrorException("childNode is not root");
        }
        NamespaceQualifiedName elemName = new NamespaceQualifiedName(childNode);
        ElementModel result = this.getNamedElement(elemName);
        return result;
    }

    public ElementModel getNamedElement(NamespaceQualifiedName name) throws SchemaException {
        if (!this.namedElements.containsKey(name)) {
            throw new InvalidSchemaException("Invalid schema. Name not found: " + name);
        }
        ElementModel result = (ElementModel)this.namedElements.get(name);
        return result;
    }

    private GroupModel getNamedGroup(NamespaceQualifiedName name) throws SchemaException {
        if (!this.namedGroups.containsKey(name)) {
            throw new InvalidSchemaException("Invalid schema. Name not found: " + name);
        }
        GroupModel result = (GroupModel)this.namedGroups.get(name);
        return result;
    }

    KeyModel getNamedKey(NamespaceQualifiedName name) throws SchemaException {
        if (!this.namedKeys.containsKey(name)) {
            throw new InvalidSchemaException("Invalid schema. Name not found: " + name);
        }
        KeyModel result = (KeyModel)this.namedKeys.get(name);
        return result;
    }

    KeyrefModel getNamedKeyref(NamespaceQualifiedName name) throws SchemaException {
        if (!this.namedKeyrefs.containsKey(name)) {
            throw new InvalidSchemaException("Invalid schema. Name not found: " + name);
        }
        KeyrefModel result = (KeyrefModel)this.namedKeyrefs.get(name);
        return result;
    }

    boolean hasNamedSimpleType(NamespaceQualifiedName name) {
        boolean result = this.namedSimpleTypes.containsKey(name);
        return result;
    }

    SimpleType getNamedSimpleType(NamespaceQualifiedName name) throws SchemaException {
        if (!this.namedSimpleTypes.containsKey(name)) {
            throw new InvalidSchemaException("Invalid schema. Name not found: " + name);
        }
        SimpleType result = (SimpleType)this.namedSimpleTypes.get(name);
        if (result == null) {
            throw new InternalErrorException("Type is undefined: " + name);
        }
        return result;
    }

    ComplexTypeModel getNamedComplexType(NamespaceQualifiedName name) throws SchemaException {
        if (!this.namedComplexTypes.containsKey(name)) {
            throw new InvalidSchemaException("Invalid schema. Name not found: " + name);
        }
        ComplexTypeModel result = (ComplexTypeModel)this.namedComplexTypes.get(name);
        return result;
    }

    AttributeModel getAttributeModel(Element schemaElement) throws SchemaException {
        String schemaType = schemaElement.getLocalName();
        if (schemaType.equals("attribute")) {
            AttributeModelImpl result = new AttributeModelImpl();
            result.load(schemaElement, this);
            return result;
        }
        throw new InternalErrorException("Internal error.  Unexpected type: " + schemaType + " " + schemaElement.getAttribute("id"));
    }

    AttributeGroupModel getAttributeGroupModel(Element schemaElement) throws SchemaException {
        String schemaType = schemaElement.getLocalName();
        if (schemaType.equals("attributeGroup")) {
            if (schemaElement.hasAttribute("ref")) {
                String ref = schemaElement.getAttribute("ref");
                NamespaceQualifiedName refName = new NamespaceQualifiedName(ref, schemaElement);
                Document schemaDocument = schemaElement.getOwnerDocument();
                return this.loadAttributeGroupModel(refName, schemaDocument);
            }
            AttributeGroupModel result = new AttributeGroupModel();
            result.load(schemaElement, this);
            return result;
        }
        throw new InternalErrorException("Internal error.  Unexpected type: " + schemaType + " " + schemaElement.getAttribute("id"));
    }

    StructureModel getStructureModelNode(Element schemaElement) throws SchemaException {
        String schemaType = schemaElement.getLocalName();
        if (schemaType.equals("annotation")) {
            return null;
        }
        int minOccurs = this.getMinOccurs(schemaElement);
        int maxOccurs = this.getMaxOccurs(schemaElement);
        if (minOccurs != 1 || maxOccurs != 1) {
            return this.getMultipleModelNode(schemaElement);
        }
        return this.getSingleModelNode(schemaElement);
    }

    private MultipleModel getMultipleModelNode(Element schemaElement) throws SchemaException {
        String schemaType = schemaElement.getLocalName();
        if (schemaType.equals("annotation")) {
            return null;
        }
        int minOccurs = this.getMinOccurs(schemaElement);
        int maxOccurs = this.getMaxOccurs(schemaElement);
        if (minOccurs == 1 && maxOccurs == 1) {
            throw new InternalErrorException("Internal error.  No need for MultipleModel, The SingleModel should be used.");
        }
        SingleModel single = this.getSingleModelNode(schemaElement);
        MultipleModel result = new MultipleModel(minOccurs, maxOccurs, single);
        return result;
    }

    SingleModel getSingleModelNode(Element schemaElement) throws SchemaException {
        SingleModel singleModelNode;
        String schemaType = schemaElement.getLocalName();
        if (schemaType.equals("annotation")) {
            return null;
        }
        if (schemaType.equals("all")) {
            singleModelNode = new AllModel(schemaElement, this);
        } else if (schemaType.equals("choice")) {
            singleModelNode = new ChoiceModel(schemaElement, this);
        } else if (schemaType.equals("element")) {
            singleModelNode = this.getElementModelNode(schemaElement);
        } else if (schemaType.equals("group")) {
            if (schemaElement.hasAttribute("ref")) {
                String ref = schemaElement.getAttribute("ref");
                NamespaceQualifiedName refName = new NamespaceQualifiedName(ref, schemaElement);
                singleModelNode = this.getNamedGroup(refName);
            } else {
                GroupModel node = new GroupModel();
                node.load(schemaElement, this);
                singleModelNode = node;
            }
        } else if (schemaType.equals("sequence")) {
            singleModelNode = new SequenceModelNode(schemaElement, this);
        } else {
            throw new NotImplementedException("Not implemented. " + schemaType);
        }
        return singleModelNode;
    }

    ComplexContent getComplexContent(Element schemaElement) throws SchemaException {
        ComplexContent result = new ComplexContent();
        result.load(schemaElement, this);
        return result;
    }

    ComplexTypeModel getComplexTypeModelNode(Element schemaElement) throws SchemaException {
        ComplexTypeModel result;
        String schemaType = schemaElement.getLocalName();
        if (schemaType.equals("annotation")) {
            return null;
        }
        if (!schemaType.equals("complexType")) {
            throw new InternalErrorException("Internal error. Unexpected type: " + schemaType);
        }
        if (schemaElement.hasAttribute("name")) {
            String prefixedTypeName = schemaElement.getAttribute("name");
            NamespaceQualifiedName typeName = new NamespaceQualifiedName(prefixedTypeName, schemaElement);
            if (!this.namedComplexTypes.containsKey(typeName)) {
                result = new ComplexTypeModel();
                result.load(schemaElement, this);
            } else {
                result = (ComplexTypeModel)this.namedComplexTypes.get(typeName);
            }
        } else {
            result = new ComplexTypeModel();
            result.load(schemaElement, this);
        }
        return result;
    }

    ElementModel getElementModelNode(Element schemaElement) throws SchemaException {
        ElementModel elementNode;
        String schemaType = schemaElement.getLocalName();
        if (schemaType.equals("annotation")) {
            return null;
        }
        if (schemaType.equals("element")) {
            if (schemaElement.hasAttribute("ref")) {
                String ref = schemaElement.getAttribute("ref");
                NamespaceQualifiedName refName = new NamespaceQualifiedName(ref, schemaElement);
                elementNode = this.getNamedElement(refName);
            } else {
                elementNode = new ElementModel();
                elementNode.load(schemaElement, this);
            }
        } else {
            throw new InternalErrorException("Internal error. schmeaType must be element.");
        }
        return elementNode;
    }

    GroupModel getGroupModelNode(Element schemaElement) throws SchemaException {
        GroupModel node;
        String schemaType = schemaElement.getLocalName();
        if (schemaType.equals("annotation")) {
            return null;
        }
        if (schemaType.equals("group")) {
            if (schemaElement.hasAttribute("ref")) {
                String ref = schemaElement.getAttribute("ref");
                NamespaceQualifiedName refName = new NamespaceQualifiedName(ref, schemaElement);
                node = this.getNamedGroup(refName);
            } else {
                node = new GroupModel();
                node.load(schemaElement, this);
            }
        } else {
            throw new InternalErrorException("Internal error. schemaType must be group.");
        }
        return node;
    }

    SimpleContentModel getSimpleContent(Element schemaElement) throws SchemaException {
        SimpleContentModel result = new SimpleContentModel(schemaElement, this);
        return result;
    }

    SimpleType getSimpleType(Element schemaElement) throws SchemaException {
        String schemaType = schemaElement.getLocalName();
        if (schemaType.equals("annotation")) {
            return null;
        }
        if (!schemaType.equals("simpleType")) {
            throw new InternalErrorException("Internal error. Unexpected type: " + schemaType);
        }
        NamedModelFactory simpleTypeFactory = new NamedModelFactory(this.namedSimpleTypes, null);
        SimpleType result = SimpleTypeFactory.createSimpleType(this.targetNamespace, schemaElement, simpleTypeFactory);
        return result;
    }

    private int getMinOccurs(Element schemaElement) {
        if (!schemaElement.hasAttribute("minOccurs")) {
            return 1;
        }
        String strValue = schemaElement.getAttribute("minOccurs");
        int value = Integer.parseInt(strValue);
        return value;
    }

    private int getMaxOccurs(Element schemaElement) {
        if (!schemaElement.hasAttribute("maxOccurs")) {
            return 1;
        }
        String strValue = schemaElement.getAttribute("maxOccurs");
        if (strValue.equals("unbounded")) {
            return Integer.MAX_VALUE;
        }
        int value = Integer.parseInt(strValue);
        return value;
    }

    private void loadDefinitions(Document schemaDoc) throws SchemaException {
        Element schemaElement = XmlUtils.getRoot(schemaDoc);
        this.targetNamespace = schemaElement.getAttribute("targetNamespace");
        this.loadBuiltInSimpleTypes();
        this.createNamedSimpleTypes(schemaDoc);
        this.createDefinitions(schemaDoc, this.namedAttributeGroups, "xs:attributeGroup", new NodeFactory(){

            @Override
            public Loadable create() {
                return new AttributeGroupModel();
            }
        });
        this.createDefinitions(schemaDoc, this.namedComplexTypes, "xs:complexType", new NodeFactory(){

            @Override
            public Loadable create() {
                return new ComplexTypeModel();
            }
        });
        this.createDefinitions(schemaDoc, this.namedElements, "xs:element", new NodeFactory(){

            @Override
            public Loadable create() {
                return new ElementModel();
            }
        });
        this.createDefinitions(schemaDoc, this.namedGroups, "xs:group", new NodeFactory(){

            @Override
            public Loadable create() {
                return new GroupModel();
            }
        });
        this.createDeepDefinitions(schemaDoc, this.namedKeys, "xs:key", new NodeFactory(){

            @Override
            public Loadable create() {
                return new KeyModel();
            }
        });
        this.createDeepDefinitions(schemaDoc, this.namedKeyrefs, "xs:keyref", new NodeFactory(){

            @Override
            public Loadable create() {
                return new KeyrefModel();
            }
        });
        this.loadDefinitions(schemaDoc, this.namedAttributeGroups, "xs:attributeGroup");
        this.loadDefinitions(schemaDoc, this.namedComplexTypes, "xs:complexType");
        this.loadDefinitions(schemaDoc, this.namedElements, "xs:element");
        this.loadDefinitions(schemaDoc, this.namedGroups, "xs:group");
        this.loadDeepDefinitions(schemaDoc, this.namedKeys, "xs:key");
        this.loadDeepDefinitions(schemaDoc, this.namedKeyrefs, "xs:keyref");
        if (this.namedElements.isEmpty()) {
            throw new InvalidSchemaException("Invalid schema. No roots defined.");
        }
    }

    private void createDefinitions(Document schemaDocument, NamedModelMap map, String typeName, NodeFactory factory) throws SchemaException {
        String path = "/xs:schema/" + typeName + "[@name]";
        this.createDefinitionsPath(schemaDocument, map, path, factory);
    }

    private void createDeepDefinitions(Document schemaDocument, NamedModelMap map, String typeName, NodeFactory factory) throws SchemaException {
        String path = "/xs:schema//" + typeName + "[@name]";
        this.createDefinitionsPath(schemaDocument, map, path, factory);
    }

    private void createDefinitionsPath(Document schemaDocument, NamedModelMap map, String path, NodeFactory factory) throws SchemaException {
        try {
            NodeList schemaNodes = XmlUtils.selectNodeList(schemaDocument, path, SchemaNamespaceContext.instance);
            int nbNodes = schemaNodes.getLength();
            for (int i = 0; i < nbNodes; ++i) {
                Element schemaElement = (Element)schemaNodes.item(i);
                String localName = schemaElement.getAttribute("name");
                NamespaceQualifiedName name = new NamespaceQualifiedName(this.targetNamespace, localName);
                Loadable node = factory.create();
                map.put(name, node);
            }
        }
        catch (XPathExpressionException ex) {
            throw new InternalErrorException(ex);
        }
    }

    private void loadBuiltInSimpleTypes() throws SchemaException {
        String xs = "http://www.w3.org/2001/XMLSchema";
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "boolean"), XsBoolean.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "date"), XsDate.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "decimal"), XsDecimal.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "float"), XsFloat.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "int"), XsInt.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "integer"), XsInteger.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "long"), XsLong.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "language"), XsLanguage.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "nonNegativeInteger"), XsNonNegativeInteger.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "nonPositiveInteger"), XsNonPositiveInteger.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "positiveInteger"), XsPositiveInteger.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "short"), XsShort.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "string"), XsString.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "unsignedInt"), XsUnsignedInt.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "NMTOKEN"), XsNMTOKEN.getInstance());
        this.namedSimpleTypes.put(new NamespaceQualifiedName(xs, "NMTOKENS"), XsNMTOKENS.getInstance());
    }

    private void createNonRecursiveDefinitions(Document schemaDocument, NamedModelMap map, String typeName, String targetNamespace, NamedModelFactory.ModelFactory factory) throws SchemaException {
        NamedModelFactory modelFactory = new NamedModelFactory(map, factory);
        modelFactory.createNonRecursiveDefinitions(schemaDocument, typeName, targetNamespace);
    }

    private void createNamedSimpleTypes(Document schemaDocument) throws SchemaException {
        NamedModelFactory.ModelFactory modelFactory = new NamedModelFactory.ModelFactory(){

            @Override
            public Named create(Element schemaElement, NamedModelFactory namedFactory) throws SchemaException {
                return SimpleTypeFactory.createSimpleType(SchemaModelImpl.this.targetNamespace, schemaElement, namedFactory);
            }
        };
        this.createNonRecursiveDefinitions(schemaDocument, this.namedSimpleTypes, "xs:simpleType", this.targetNamespace, modelFactory);
    }

    AttributeGroupModel loadAttributeGroupModel(NamespaceQualifiedName name, Document schemaDocument) throws SchemaException {
        AttributeGroupModel groupModel = (AttributeGroupModel)this.namedAttributeGroups.get(name);
        if (groupModel == null) {
            throw new InvalidSchemaException("attributeGroup not defined:" + name);
        }
        if (!groupModel.isLoaded()) {
            NodeList schemaNodes;
            String path = "/xs:schema/xs:attributeGroup[@name='" + name.getName() + "']";
            try {
                schemaNodes = XmlUtils.selectNodeList(schemaDocument, path, SchemaNamespaceContext.instance);
            }
            catch (XPathExpressionException e) {
                throw new InternalErrorException(e);
            }
            if (schemaNodes.getLength() != 1) {
                throw new InvalidSchemaException("Error retrieving attributeGroup " + name);
            }
            Element schemaElement = (Element)schemaNodes.item(0);
            groupModel.load(schemaElement, this);
        }
        return groupModel;
    }

    ComplexTypeModel loadComplexTypeModel(NamespaceQualifiedName name, Document schemaDocument) throws SchemaException {
        ComplexTypeModel complexTypeModel = (ComplexTypeModel)this.namedComplexTypes.get(name);
        if (complexTypeModel == null) {
            throw new InvalidSchemaException("complex type not defined:" + name);
        }
        if (!complexTypeModel.isLoaded()) {
            NodeList schemaNodes;
            String path = "/xs:schema/xs:complexType[@name='" + name.getName() + "']";
            try {
                schemaNodes = XmlUtils.selectNodeList(schemaDocument, path, SchemaNamespaceContext.instance);
            }
            catch (XPathExpressionException e) {
                throw new InternalErrorException(e);
            }
            if (schemaNodes.getLength() != 1) {
                throw new InvalidSchemaException("Error retrieving complexType " + name);
            }
            Element schemaElement = (Element)schemaNodes.item(0);
            complexTypeModel.load(schemaElement, this);
        }
        return complexTypeModel;
    }

    private void loadDefinitions(Document schemaDocument, NamedModelMap map, String typeName) throws SchemaException {
        String path = "/xs:schema/" + typeName + "[@name]";
        this.loadDefinitionsPath(schemaDocument, map, path);
    }

    private void loadDeepDefinitions(Document schemaDocument, NamedModelMap map, String typeName) throws SchemaException {
        String path = "/xs:schema//" + typeName + "[@name]";
        this.loadDefinitionsPath(schemaDocument, map, path);
    }

    private void loadDefinitionsPath(Document schemaDocument, NamedModelMap map, String path) throws SchemaException {
        try {
            NodeList schemaNodes = XmlUtils.selectNodeList(schemaDocument, path, SchemaNamespaceContext.instance);
            int nbNodes = schemaNodes.getLength();
            for (int i = 0; i < nbNodes; ++i) {
                Element schemaElement = (Element)schemaNodes.item(i);
                String localName = schemaElement.getAttribute("name");
                NamespaceQualifiedName name = new NamespaceQualifiedName(this.targetNamespace, localName);
                Loadable node = (Loadable)map.get(name);
                node.load(schemaElement, this);
            }
        }
        catch (XPathExpressionException ex) {
            throw new InternalErrorException(ex);
        }
    }

    private static interface NodeFactory {
        public Loadable create();
    }
}

