/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.LookaheadResult;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.SingleModel;
import com.cognos.rspecupgrade.internal.xml.schema.StructureModel;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SequenceModelNode
implements SingleModel {
    private LinkedList<StructureModel> children = new LinkedList();

    SequenceModelNode(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        Node schemaChild = schemaElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            StructureModel modelNode;
            Element childElement = (Element)schemaChild;
            String type = childElement.getLocalName();
            if (!type.equals("annotation") && (modelNode = model.getStructureModelNode(childElement)) != null) {
                this.children.addLast(modelNode);
            }
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
    }

    @Override
    public LookaheadResult lookahead(Node docNode) throws SchemaException {
        for (StructureModel childNode : this.children) {
            LookaheadResult result = childNode.lookahead(docNode);
            if (result == LookaheadResult.Yes) {
                return LookaheadResult.Yes;
            }
            if (result != LookaheadResult.No) continue;
            return LookaheadResult.No;
        }
        return LookaheadResult.NoTokensConsumed;
    }

    @Override
    public Node consume(Node parentNode, Node docNode, DocumentFixer fixer) throws SchemaException {
        if (this.lookahead(docNode) != LookaheadResult.Yes) {
            throw new InternalErrorException("Internal error. Consuming when there is no match. Create should be called first to make the lookahead pass.");
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            docNode = XmlUtils.skipBlankTextAndComments(docNode);
            StructureModel childNode = (StructureModel)iter.next();
            LookaheadResult lookaheadResult = childNode.lookahead(docNode);
            if (LookaheadResult.Yes == lookaheadResult) {
                docNode = childNode.consume(parentNode, docNode, fixer);
                continue;
            }
            if (LookaheadResult.No != lookaheadResult) continue;
            docNode = childNode.create(parentNode, docNode, fixer);
        }
        return docNode;
    }

    @Override
    public Node create(Node parentNode, Node nextSibling, DocumentFixer fixer) throws SchemaException {
        StructureModel child = this.children.getFirst();
        Node result = child.create(parentNode, nextSibling, fixer);
        return result;
    }

    @Override
    public int getMinOccurs() {
        return 1;
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        if (child instanceof Attr) {
            throw new InternalErrorException("Sequences do not define attributes");
        }
        for (StructureModel childModel : this.children) {
            ContentModel result = childModel.getModel(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean definesElement(String elementName) throws SchemaException {
        for (StructureModel childModel : this.children) {
            if (!childModel.definesElement(elementName)) continue;
            return true;
        }
        return false;
    }
}

