/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.NamedModelFactory;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.NotImplementedException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleTypeRestrictionImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SimpleTypeFactory {
    SimpleTypeFactory() {
    }

    static SimpleType createSimpleType(String targetNamespace, Element schemaElement, NamedModelFactory namedSimpleTypeFactory) throws SchemaException {
        if (targetNamespace.length() <= 0) {
            throw new InternalError("targetNamespace expected.");
        }
        SimpleTypeRestrictionImpl result = null;
        if (!schemaElement.getLocalName().equals("simpleType")) {
            throw new InternalError("Internal error.  simpleType expected.");
        }
        NamespaceQualifiedName typeName = null;
        if (schemaElement.hasAttribute("name")) {
            String name = schemaElement.getAttribute("name");
            typeName = new NamespaceQualifiedName(targetNamespace, name);
        }
        if (schemaElement.hasAttribute("final")) {
            throw new NotImplementedException("Not implemented.  Attribute final.");
        }
        Node childNode = schemaElement.getFirstChild();
        childNode = XmlUtils.skipBlankTextAndComments(childNode);
        while (childNode != null) {
            Element childElement = (Element)childNode;
            String schemaType = childElement.getLocalName();
            if (!schemaType.equals("annotation")) {
                if (schemaType.equals("list")) {
                    throw new NotImplementedException("Not implemented. list");
                }
                if (schemaType.equals("union")) {
                    throw new NotImplementedException("Not implemented. union");
                }
                if (schemaType.equals("restriction")) {
                    if (result != null) {
                        throw new InvalidSchemaException("Invalid schema. More than one type");
                    }
                    result = new SimpleTypeRestrictionImpl(typeName, childElement, namedSimpleTypeFactory);
                }
            }
            childNode = childNode.getNextSibling();
            childNode = XmlUtils.skipBlankTextAndComments(childNode);
        }
        if (result == null) {
            throw new InternalErrorException("implementation should not be null.");
        }
        return result;
    }
}

