/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.MessageGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.NamedModelFactory;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.Range;
import com.cognos.rspecupgrade.internal.xml.schema.Restrictions;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import com.cognos.rspecupgrade.internal.xml.xpath.XPathGenerator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SimpleTypeRestrictionImpl
implements SimpleType {
    final Restrictions restrictions;
    private String sampleValue = null;
    private final NamespaceQualifiedName name;

    protected SimpleTypeRestrictionImpl(SimpleType baseType, NamespaceQualifiedName typeName) {
        this.name = typeName;
        this.restrictions = new Restrictions(baseType);
    }

    private void loadSampleValue(Element simpleTypeElement) throws InvalidSchemaException {
        final Attr sampleValueAttr = simpleTypeElement.getAttributeNodeNS("http://developer.cognos.com/schemas/rspecExtension/", "validSample");
        if (sampleValueAttr != null) {
            this.sampleValue = sampleValueAttr.getValue();
            MessageGenerator errorMessage = new MessageGenerator(){

                @Override
                public String getMessage() {
                    String path = XPathGenerator.getXPath(sampleValueAttr);
                    return "Sample value (" + SimpleTypeRestrictionImpl.this.sampleValue + ") is not valid at " + path;
                }
            };
            this.assertIsValidValue(this.sampleValue, errorMessage);
        }
    }

    private void assertValidValueCanBeDetermined(final MessageGenerator errorMessage) throws InvalidSchemaException {
        try {
            final String validValue = this.getValidValue();
            MessageGenerator message = new MessageGenerator(){

                @Override
                public String getMessage() {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Unable to determine valid value for simple type ");
                    if (SimpleTypeRestrictionImpl.this.name == null) {
                        buffer.append("anonymous");
                    } else {
                        buffer.append(SimpleTypeRestrictionImpl.this.name);
                    }
                    buffer.append(". Valid value tested is ");
                    buffer.append(validValue);
                    buffer.append("\n");
                    buffer.append(errorMessage.getMessage());
                    return buffer.toString();
                }
            };
            this.assertIsValidValue(validValue, message);
        }
        catch (InvalidSchemaException e) {
            throw new InvalidSchemaException(errorMessage.getMessage(), e);
        }
        catch (SchemaException e) {
            throw new InvalidSchemaException(errorMessage.getMessage(), e);
        }
    }

    SimpleTypeRestrictionImpl(NamespaceQualifiedName typeName, final Element schemaElement, NamedModelFactory simpleTypeFactory) throws SchemaException {
        this.name = typeName;
        this.restrictions = new Restrictions(schemaElement, simpleTypeFactory);
        this.loadSampleValue((Element)schemaElement.getParentNode());
        this.assertValidValueCanBeDetermined(new MessageGenerator(){

            @Override
            public String getMessage() {
                String path = XPathGenerator.getXPath(schemaElement);
                String message = "Unable to determine a valid value for " + SimpleTypeRestrictionImpl.this.name.toString() + " located at " + path;
                return message;
            }
        });
    }

    @Override
    public boolean isValidValue(String lexicalValue) {
        return this.restrictions.isValidValue(lexicalValue);
    }

    @Override
    public String getValidValue() throws SchemaException {
        if (this.sampleValue != null) {
            return this.sampleValue;
        }
        return this.restrictions.getValidValue();
    }

    @Override
    public String verifyAndFix(String text) throws SchemaException {
        if (this.isValidValue(text)) {
            return text;
        }
        if (this.sampleValue != null) {
            return this.sampleValue;
        }
        return this.restrictions.getValidValue(text);
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws SchemaException {
        return this.restrictions.getSemanticValue(lexicalValue);
    }

    @Override
    public boolean definesAttribute(String attributeName) {
        return this.restrictions.baseImplementation.definesAttribute(attributeName);
    }

    @Override
    public boolean definesElement(String elementName) throws SchemaException {
        return this.restrictions.baseImplementation.definesElement(elementName);
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        return this.restrictions.baseImplementation.getModel(child);
    }

    @Override
    public Range newRangeInstance(String minExclusive, String minInclusive, String maxInclusive, String maxExclusive) throws SchemaException {
        return this.restrictions.newRangeInstance(minExclusive, minInclusive, maxInclusive, maxExclusive);
    }

    @Override
    public NamespaceQualifiedName getName() {
        return this.name;
    }

    @Override
    public void assertIsValidValue(String lexicalValue, MessageGenerator message) throws InvalidSchemaException {
        this.restrictions.assertIsValidValue(lexicalValue, message);
    }
}

