/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.Field;
import com.cognos.rspecupgrade.internal.xml.schema.Fields;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.selector.ParseException;
import com.cognos.rspecupgrade.internal.xml.schema.selector.SelectorPath;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.Selector;
import java.util.HashSet;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class UniqueConstraint {
    private String name;
    private Selector selector;
    private Fields fields;

    public UniqueConstraint(Element schemaElement, SchemaModelImpl schemaModel) throws SchemaException {
        this.name = schemaElement.getAttribute("name");
        Element selectorElem = XmlUtils.getFirstChildElementByName(schemaElement, "selector");
        if (selectorElem == null) {
            throw new InvalidSchemaException("unique must have selector element");
        }
        String xpath = selectorElem.getAttribute("xpath");
        try {
            this.selector = SelectorPath.compile(xpath, schemaElement);
        }
        catch (ParseException e) {
            throw new InvalidSchemaException(e);
        }
        this.fields = new Fields();
        NodeList fieldElements = XmlUtils.getChildElementsByName(schemaElement, "field");
        int nbFieldElements = fieldElements.getLength();
        for (int i = 0; i < nbFieldElements; ++i) {
            Element fieldElement = (Element)fieldElements.item(i);
            Field field = new Field(fieldElement, schemaModel);
            this.fields.add(field);
        }
    }

    public String getName() {
        return this.name;
    }

    public void validate(Element docElement, DocumentFixer fixer) throws SchemaException {
        HashSet<Vector<Object>> values = new HashSet<Vector<Object>>();
        NodeList nodes = this.selector.evaluate(docElement);
        int nbNodes = nodes.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) {
                throw new InvalidSchemaException("Selector for unique constraint " + this.name + " returned a non-element");
            }
            Element elem = (Element)node;
            if (!this.fields.isDefined(elem)) continue;
            Vector<Object> value = this.fields.getSemanticValue(elem);
            if (!values.contains(value)) {
                values.add(value);
                continue;
            }
            fixer.notUnique(elem, this.name);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        buffer.append(this.getClass().getName());
        buffer.append(" name=");
        buffer.append(this.name);
        buffer.append('}');
        return buffer.toString();
    }
}

