/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DoubleRange;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSimpleTypeValue;
import com.cognos.rspecupgrade.internal.xml.schema.MessageGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.Range;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.w3c.dom.Node;

class XsFloat
implements SimpleType {
    private static final NamespaceQualifiedName name = new NamespaceQualifiedName("http://www.w3.org/2001/XMLSchema", "float");
    private static Pattern pattern;
    private static XsFloat instance;

    protected XsFloat() {
    }

    @Override
    public NamespaceQualifiedName getName() {
        return name;
    }

    @Override
    public Range newRangeInstance(String minExclusive, String minInclusive, String maxInclusive, String maxExclusive) throws SchemaException {
        return new DoubleRange(minExclusive, minInclusive, maxInclusive, maxExclusive);
    }

    @Override
    public String getValidValue() {
        return "0.0";
    }

    @Override
    public String verifyAndFix(String text) throws SchemaException {
        if (this.isValidValue(text)) {
            return text;
        }
        return this.getValidValue();
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws InvalidSimpleTypeValue {
        if (!this.isValidValue(lexicalValue)) {
            throw new InvalidSimpleTypeValue(lexicalValue, this);
        }
        return new Double(lexicalValue);
    }

    @Override
    public boolean definesAttribute(String attributeName) {
        return false;
    }

    @Override
    public boolean definesElement(String elementName) {
        return false;
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        return null;
    }

    @Override
    public boolean isValidValue(String text) {
        Perl5Matcher matcher = new Perl5Matcher();
        if (!matcher.matches(text, pattern)) {
            return false;
        }
        Double.parseDouble(text);
        return true;
    }

    @Override
    public void assertIsValidValue(String value, MessageGenerator message) throws InvalidSchemaException {
        if (!this.isValidValue(value)) {
            throw new InvalidSchemaException(message.getMessage());
        }
    }

    static synchronized XsFloat getInstance() throws SchemaException {
        if (instance == null) {
            try {
                Perl5Compiler compiler = new Perl5Compiler();
                pattern = compiler.compile("^\\s*((\\-|\\+)?(([0-9]+(\\.[0-9]*)?)|(\\.[0-9]+))((e|E)(\\-|\\+)?[0-9]+)?)|(\\-?((INF)|(NaN)))");
            }
            catch (MalformedPatternException ex) {
                throw new SchemaException(ex);
            }
            instance = new XsFloat();
        }
        return instance;
    }

    static {
        instance = null;
    }
}

