/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSimpleTypeValue;
import com.cognos.rspecupgrade.internal.xml.schema.MessageGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import com.cognos.rspecupgrade.internal.xml.schema.XsIntegralNumber;
import java.math.BigInteger;

class XsInteger
extends XsIntegralNumber
implements SimpleType {
    private static final NamespaceQualifiedName name = new NamespaceQualifiedName("http://www.w3.org/2001/XMLSchema", "integer");
    private static XsInteger instance = null;

    protected XsInteger() throws SchemaException {
        super(null, null);
    }

    protected XsInteger(BigInteger min, BigInteger max) throws SchemaException {
        super(min, max);
    }

    @Override
    public NamespaceQualifiedName getName() {
        return name;
    }

    @Override
    public void assertIsValidValue(String value, MessageGenerator message) throws InvalidSchemaException {
        if (!this.isValidValue(value)) {
            throw new InvalidSchemaException(message.getMessage());
        }
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws InvalidSimpleTypeValue {
        if (!this.isValidValue(lexicalValue)) {
            throw new InvalidSimpleTypeValue(lexicalValue, this);
        }
        return new Long(lexicalValue);
    }

    static synchronized XsInteger getInstance() throws SchemaException {
        if (instance == null) {
            instance = new XsInteger();
        }
        return instance;
    }
}

